# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetFlinkRegionResult',
    'AwaitableGetFlinkRegionResult',
    'get_flink_region',
    'get_flink_region_output',
]

@pulumi.output_type
class GetFlinkRegionResult:
    """
    A collection of values returned by getFlinkRegion.
    """
    def __init__(__self__, api_version=None, cloud=None, id=None, kind=None, private_rest_endpoint=None, region=None, rest_endpoint=None):
        if api_version and not isinstance(api_version, str):
            raise TypeError("Expected argument 'api_version' to be a str")
        pulumi.set(__self__, "api_version", api_version)
        if cloud and not isinstance(cloud, str):
            raise TypeError("Expected argument 'cloud' to be a str")
        pulumi.set(__self__, "cloud", cloud)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if private_rest_endpoint and not isinstance(private_rest_endpoint, str):
            raise TypeError("Expected argument 'private_rest_endpoint' to be a str")
        pulumi.set(__self__, "private_rest_endpoint", private_rest_endpoint)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rest_endpoint and not isinstance(rest_endpoint, str):
            raise TypeError("Expected argument 'rest_endpoint' to be a str")
        pulumi.set(__self__, "rest_endpoint", rest_endpoint)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> builtins.str:
        """
        (Required String) An API Version of the Flink region, for example, `fcpm/v2`.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def cloud(self) -> builtins.str:
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        (Required String) The ID of the Flink region, for example, `aws.us-east-1`.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> builtins.str:
        """
        (Required String) A kind of the Flink region, for example, `Region`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="privateRestEndpoint")
    def private_rest_endpoint(self) -> builtins.str:
        """
        (Required String) The private HTTP endpoint of the Flink region, for example, `https://flink.us-east-1.aws.private.confluent.cloud`.
        """
        return pulumi.get(self, "private_rest_endpoint")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> builtins.str:
        """
        (Required String) The HTTP endpoint of the Flink region, for example, `https://flink.us-east-1.aws.confluent.cloud`.
        """
        return pulumi.get(self, "rest_endpoint")


class AwaitableGetFlinkRegionResult(GetFlinkRegionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlinkRegionResult(
            api_version=self.api_version,
            cloud=self.cloud,
            id=self.id,
            kind=self.kind,
            private_rest_endpoint=self.private_rest_endpoint,
            region=self.region,
            rest_endpoint=self.rest_endpoint)


def get_flink_region(cloud: Optional[builtins.str] = None,
                     region: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlinkRegionResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `get_flink_region` describes a Flink cluster data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_flink_region(cloud="AWS",
        region="us-east-1")
    pulumi.export("example", example)
    ```


    :param builtins.str cloud: The cloud service provider that hosts the region. Accepted values are: `AWS`, `AZURE`, and `GCP`.
    :param builtins.str region: The cloud service provider region, for example, `us-east-1`.
    """
    __args__ = dict()
    __args__['cloud'] = cloud
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getFlinkRegion:getFlinkRegion', __args__, opts=opts, typ=GetFlinkRegionResult).value

    return AwaitableGetFlinkRegionResult(
        api_version=pulumi.get(__ret__, 'api_version'),
        cloud=pulumi.get(__ret__, 'cloud'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        private_rest_endpoint=pulumi.get(__ret__, 'private_rest_endpoint'),
        region=pulumi.get(__ret__, 'region'),
        rest_endpoint=pulumi.get(__ret__, 'rest_endpoint'))
def get_flink_region_output(cloud: Optional[pulumi.Input[builtins.str]] = None,
                            region: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlinkRegionResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `get_flink_region` describes a Flink cluster data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_flink_region(cloud="AWS",
        region="us-east-1")
    pulumi.export("example", example)
    ```


    :param builtins.str cloud: The cloud service provider that hosts the region. Accepted values are: `AWS`, `AZURE`, and `GCP`.
    :param builtins.str region: The cloud service provider region, for example, `us-east-1`.
    """
    __args__ = dict()
    __args__['cloud'] = cloud
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getFlinkRegion:getFlinkRegion', __args__, opts=opts, typ=GetFlinkRegionResult)
    return __ret__.apply(lambda __response__: GetFlinkRegionResult(
        api_version=pulumi.get(__response__, 'api_version'),
        cloud=pulumi.get(__response__, 'cloud'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        private_rest_endpoint=pulumi.get(__response__, 'private_rest_endpoint'),
        region=pulumi.get(__response__, 'region'),
        rest_endpoint=pulumi.get(__response__, 'rest_endpoint')))
