# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSchemaRegistryClusterConfigResult',
    'AwaitableGetSchemaRegistryClusterConfigResult',
    'get_schema_registry_cluster_config',
    'get_schema_registry_cluster_config_output',
]

@pulumi.output_type
class GetSchemaRegistryClusterConfigResult:
    """
    A collection of values returned by getSchemaRegistryClusterConfig.
    """
    def __init__(__self__, compatibility_group=None, compatibility_level=None, credentials=None, id=None, rest_endpoint=None, schema_registry_cluster=None):
        if compatibility_group and not isinstance(compatibility_group, str):
            raise TypeError("Expected argument 'compatibility_group' to be a str")
        pulumi.set(__self__, "compatibility_group", compatibility_group)
        if compatibility_level and not isinstance(compatibility_level, str):
            raise TypeError("Expected argument 'compatibility_level' to be a str")
        pulumi.set(__self__, "compatibility_level", compatibility_level)
        if credentials and not isinstance(credentials, dict):
            raise TypeError("Expected argument 'credentials' to be a dict")
        pulumi.set(__self__, "credentials", credentials)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rest_endpoint and not isinstance(rest_endpoint, str):
            raise TypeError("Expected argument 'rest_endpoint' to be a str")
        pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if schema_registry_cluster and not isinstance(schema_registry_cluster, dict):
            raise TypeError("Expected argument 'schema_registry_cluster' to be a dict")
        pulumi.set(__self__, "schema_registry_cluster", schema_registry_cluster)

    @property
    @pulumi.getter(name="compatibilityGroup")
    def compatibility_group(self) -> builtins.str:
        """
        (Required String) The global Schema Registry compatibility group.
        """
        return pulumi.get(self, "compatibility_group")

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> builtins.str:
        """
        (Required String) The global Schema Registry compatibility level. Accepted values are: `BACKWARD`, `BACKWARD_TRANSITIVE`, `FORWARD`, `FORWARD_TRANSITIVE`, `FULL`, `FULL_TRANSITIVE`, and `NONE`. See the [Compatibility Types](https://docs.confluent.io/platform/current/schema-registry/avro.html#compatibility-types) for more details.
        """
        return pulumi.get(self, "compatibility_level")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.GetSchemaRegistryClusterConfigCredentialsResult']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "rest_endpoint")

    @property
    @pulumi.getter(name="schemaRegistryCluster")
    def schema_registry_cluster(self) -> Optional['outputs.GetSchemaRegistryClusterConfigSchemaRegistryClusterResult']:
        return pulumi.get(self, "schema_registry_cluster")


class AwaitableGetSchemaRegistryClusterConfigResult(GetSchemaRegistryClusterConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSchemaRegistryClusterConfigResult(
            compatibility_group=self.compatibility_group,
            compatibility_level=self.compatibility_level,
            credentials=self.credentials,
            id=self.id,
            rest_endpoint=self.rest_endpoint,
            schema_registry_cluster=self.schema_registry_cluster)


def get_schema_registry_cluster_config(credentials: Optional[Union['GetSchemaRegistryClusterConfigCredentialsArgs', 'GetSchemaRegistryClusterConfigCredentialsArgsDict']] = None,
                                       rest_endpoint: Optional[builtins.str] = None,
                                       schema_registry_cluster: Optional[Union['GetSchemaRegistryClusterConfigSchemaRegistryClusterArgs', 'GetSchemaRegistryClusterConfigSchemaRegistryClusterArgsDict']] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSchemaRegistryClusterConfigResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `SchemaRegistryClusterConfig` describes a Schema Registry Cluster Config data source.

    ## Example Usage

    ### Option #1: Manage multiple Schema Registry clusters in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_schema_registry_cluster_config(schema_registry_cluster={
            "id": essentials["id"],
        },
        rest_endpoint=essentials["restEndpoint"],
        credentials={
            "key": "<Schema Registry API Key for data.confluent_schema_registry_cluster.essentials>",
            "secret": "<Schema Registry API Secret for data.confluent_schema_registry_cluster.essentials>",
        })
    pulumi.export("compatibilityLevel", example.compatibility_level)
    ```

    ### Option #2: Manage a single Schema Registry cluster in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_schema_registry_cluster_config()
    pulumi.export("compatibilityLevel", example.compatibility_level)
    ```


    :param builtins.str rest_endpoint: The REST endpoint of the Schema Registry cluster, for example, `https://psrc-00000.us-central1.gcp.confluent.cloud:443`).
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['restEndpoint'] = rest_endpoint
    __args__['schemaRegistryCluster'] = schema_registry_cluster
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getSchemaRegistryClusterConfig:getSchemaRegistryClusterConfig', __args__, opts=opts, typ=GetSchemaRegistryClusterConfigResult).value

    return AwaitableGetSchemaRegistryClusterConfigResult(
        compatibility_group=pulumi.get(__ret__, 'compatibility_group'),
        compatibility_level=pulumi.get(__ret__, 'compatibility_level'),
        credentials=pulumi.get(__ret__, 'credentials'),
        id=pulumi.get(__ret__, 'id'),
        rest_endpoint=pulumi.get(__ret__, 'rest_endpoint'),
        schema_registry_cluster=pulumi.get(__ret__, 'schema_registry_cluster'))
def get_schema_registry_cluster_config_output(credentials: Optional[pulumi.Input[Optional[Union['GetSchemaRegistryClusterConfigCredentialsArgs', 'GetSchemaRegistryClusterConfigCredentialsArgsDict']]]] = None,
                                              rest_endpoint: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                              schema_registry_cluster: Optional[pulumi.Input[Optional[Union['GetSchemaRegistryClusterConfigSchemaRegistryClusterArgs', 'GetSchemaRegistryClusterConfigSchemaRegistryClusterArgsDict']]]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSchemaRegistryClusterConfigResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `SchemaRegistryClusterConfig` describes a Schema Registry Cluster Config data source.

    ## Example Usage

    ### Option #1: Manage multiple Schema Registry clusters in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_schema_registry_cluster_config(schema_registry_cluster={
            "id": essentials["id"],
        },
        rest_endpoint=essentials["restEndpoint"],
        credentials={
            "key": "<Schema Registry API Key for data.confluent_schema_registry_cluster.essentials>",
            "secret": "<Schema Registry API Secret for data.confluent_schema_registry_cluster.essentials>",
        })
    pulumi.export("compatibilityLevel", example.compatibility_level)
    ```

    ### Option #2: Manage a single Schema Registry cluster in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_schema_registry_cluster_config()
    pulumi.export("compatibilityLevel", example.compatibility_level)
    ```


    :param builtins.str rest_endpoint: The REST endpoint of the Schema Registry cluster, for example, `https://psrc-00000.us-central1.gcp.confluent.cloud:443`).
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['restEndpoint'] = rest_endpoint
    __args__['schemaRegistryCluster'] = schema_registry_cluster
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getSchemaRegistryClusterConfig:getSchemaRegistryClusterConfig', __args__, opts=opts, typ=GetSchemaRegistryClusterConfigResult)
    return __ret__.apply(lambda __response__: GetSchemaRegistryClusterConfigResult(
        compatibility_group=pulumi.get(__response__, 'compatibility_group'),
        compatibility_level=pulumi.get(__response__, 'compatibility_level'),
        credentials=pulumi.get(__response__, 'credentials'),
        id=pulumi.get(__response__, 'id'),
        rest_endpoint=pulumi.get(__response__, 'rest_endpoint'),
        schema_registry_cluster=pulumi.get(__response__, 'schema_registry_cluster')))
