# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSubjectConfigResult',
    'AwaitableGetSubjectConfigResult',
    'get_subject_config',
    'get_subject_config_output',
]

@pulumi.output_type
class GetSubjectConfigResult:
    """
    A collection of values returned by getSubjectConfig.
    """
    def __init__(__self__, compatibility_group=None, compatibility_level=None, credentials=None, id=None, rest_endpoint=None, schema_registry_cluster=None, subject_name=None):
        if compatibility_group and not isinstance(compatibility_group, str):
            raise TypeError("Expected argument 'compatibility_group' to be a str")
        pulumi.set(__self__, "compatibility_group", compatibility_group)
        if compatibility_level and not isinstance(compatibility_level, str):
            raise TypeError("Expected argument 'compatibility_level' to be a str")
        pulumi.set(__self__, "compatibility_level", compatibility_level)
        if credentials and not isinstance(credentials, dict):
            raise TypeError("Expected argument 'credentials' to be a dict")
        pulumi.set(__self__, "credentials", credentials)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rest_endpoint and not isinstance(rest_endpoint, str):
            raise TypeError("Expected argument 'rest_endpoint' to be a str")
        pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if schema_registry_cluster and not isinstance(schema_registry_cluster, dict):
            raise TypeError("Expected argument 'schema_registry_cluster' to be a dict")
        pulumi.set(__self__, "schema_registry_cluster", schema_registry_cluster)
        if subject_name and not isinstance(subject_name, str):
            raise TypeError("Expected argument 'subject_name' to be a str")
        pulumi.set(__self__, "subject_name", subject_name)

    @property
    @pulumi.getter(name="compatibilityGroup")
    def compatibility_group(self) -> builtins.str:
        """
        (Required String) The Compatibility Group of the specified subject.
        """
        return pulumi.get(self, "compatibility_group")

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> builtins.str:
        """
        (Required String) The Compatibility Level of the specified subject. Accepted values are: `BACKWARD`, `BACKWARD_TRANSITIVE`, `FORWARD`, `FORWARD_TRANSITIVE`, `FULL`, `FULL_TRANSITIVE`, and `NONE`. See the [Compatibility Types](https://docs.confluent.io/platform/current/schema-registry/avro.html#compatibility-types) for more details.
        """
        return pulumi.get(self, "compatibility_level")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.GetSubjectConfigCredentialsResult']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "rest_endpoint")

    @property
    @pulumi.getter(name="schemaRegistryCluster")
    def schema_registry_cluster(self) -> Optional['outputs.GetSubjectConfigSchemaRegistryClusterResult']:
        return pulumi.get(self, "schema_registry_cluster")

    @property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> builtins.str:
        return pulumi.get(self, "subject_name")


class AwaitableGetSubjectConfigResult(GetSubjectConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubjectConfigResult(
            compatibility_group=self.compatibility_group,
            compatibility_level=self.compatibility_level,
            credentials=self.credentials,
            id=self.id,
            rest_endpoint=self.rest_endpoint,
            schema_registry_cluster=self.schema_registry_cluster,
            subject_name=self.subject_name)


def get_subject_config(credentials: Optional[Union['GetSubjectConfigCredentialsArgs', 'GetSubjectConfigCredentialsArgsDict']] = None,
                       rest_endpoint: Optional[builtins.str] = None,
                       schema_registry_cluster: Optional[Union['GetSubjectConfigSchemaRegistryClusterArgs', 'GetSubjectConfigSchemaRegistryClusterArgsDict']] = None,
                       subject_name: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubjectConfigResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `confluent_subject_compatibility_level` describes a Subject Config data source.

    ## Example Usage


    :param builtins.str rest_endpoint: The REST endpoint of the Schema Registry cluster, for example, `https://psrc-00000.us-central1.gcp.confluent.cloud:443`).
    :param builtins.str subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['restEndpoint'] = rest_endpoint
    __args__['schemaRegistryCluster'] = schema_registry_cluster
    __args__['subjectName'] = subject_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getSubjectConfig:getSubjectConfig', __args__, opts=opts, typ=GetSubjectConfigResult).value

    return AwaitableGetSubjectConfigResult(
        compatibility_group=pulumi.get(__ret__, 'compatibility_group'),
        compatibility_level=pulumi.get(__ret__, 'compatibility_level'),
        credentials=pulumi.get(__ret__, 'credentials'),
        id=pulumi.get(__ret__, 'id'),
        rest_endpoint=pulumi.get(__ret__, 'rest_endpoint'),
        schema_registry_cluster=pulumi.get(__ret__, 'schema_registry_cluster'),
        subject_name=pulumi.get(__ret__, 'subject_name'))
def get_subject_config_output(credentials: Optional[pulumi.Input[Optional[Union['GetSubjectConfigCredentialsArgs', 'GetSubjectConfigCredentialsArgsDict']]]] = None,
                              rest_endpoint: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                              schema_registry_cluster: Optional[pulumi.Input[Optional[Union['GetSubjectConfigSchemaRegistryClusterArgs', 'GetSubjectConfigSchemaRegistryClusterArgsDict']]]] = None,
                              subject_name: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubjectConfigResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `confluent_subject_compatibility_level` describes a Subject Config data source.

    ## Example Usage


    :param builtins.str rest_endpoint: The REST endpoint of the Schema Registry cluster, for example, `https://psrc-00000.us-central1.gcp.confluent.cloud:443`).
    :param builtins.str subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['restEndpoint'] = rest_endpoint
    __args__['schemaRegistryCluster'] = schema_registry_cluster
    __args__['subjectName'] = subject_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getSubjectConfig:getSubjectConfig', __args__, opts=opts, typ=GetSubjectConfigResult)
    return __ret__.apply(lambda __response__: GetSubjectConfigResult(
        compatibility_group=pulumi.get(__response__, 'compatibility_group'),
        compatibility_level=pulumi.get(__response__, 'compatibility_level'),
        credentials=pulumi.get(__response__, 'credentials'),
        id=pulumi.get(__response__, 'id'),
        rest_endpoint=pulumi.get(__response__, 'rest_endpoint'),
        schema_registry_cluster=pulumi.get(__response__, 'schema_registry_cluster'),
        subject_name=pulumi.get(__response__, 'subject_name')))
