# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSubjectModeResult',
    'AwaitableGetSubjectModeResult',
    'get_subject_mode',
    'get_subject_mode_output',
]

@pulumi.output_type
class GetSubjectModeResult:
    """
    A collection of values returned by getSubjectMode.
    """
    def __init__(__self__, credentials=None, id=None, mode=None, rest_endpoint=None, schema_registry_cluster=None, subject_name=None):
        if credentials and not isinstance(credentials, dict):
            raise TypeError("Expected argument 'credentials' to be a dict")
        pulumi.set(__self__, "credentials", credentials)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mode and not isinstance(mode, str):
            raise TypeError("Expected argument 'mode' to be a str")
        pulumi.set(__self__, "mode", mode)
        if rest_endpoint and not isinstance(rest_endpoint, str):
            raise TypeError("Expected argument 'rest_endpoint' to be a str")
        pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if schema_registry_cluster and not isinstance(schema_registry_cluster, dict):
            raise TypeError("Expected argument 'schema_registry_cluster' to be a dict")
        pulumi.set(__self__, "schema_registry_cluster", schema_registry_cluster)
        if subject_name and not isinstance(subject_name, str):
            raise TypeError("Expected argument 'subject_name' to be a str")
        pulumi.set(__self__, "subject_name", subject_name)

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.GetSubjectModeCredentialsResult']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mode(self) -> builtins.str:
        """
        (Required String) The mode of the specified subject. Accepted values are: `READWRITE`, `READONLY`, `READONLY_OVERRIDE`, and `IMPORT`.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "rest_endpoint")

    @property
    @pulumi.getter(name="schemaRegistryCluster")
    def schema_registry_cluster(self) -> Optional['outputs.GetSubjectModeSchemaRegistryClusterResult']:
        return pulumi.get(self, "schema_registry_cluster")

    @property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> builtins.str:
        return pulumi.get(self, "subject_name")


class AwaitableGetSubjectModeResult(GetSubjectModeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubjectModeResult(
            credentials=self.credentials,
            id=self.id,
            mode=self.mode,
            rest_endpoint=self.rest_endpoint,
            schema_registry_cluster=self.schema_registry_cluster,
            subject_name=self.subject_name)


def get_subject_mode(credentials: Optional[Union['GetSubjectModeCredentialsArgs', 'GetSubjectModeCredentialsArgsDict']] = None,
                     rest_endpoint: Optional[builtins.str] = None,
                     schema_registry_cluster: Optional[Union['GetSubjectModeSchemaRegistryClusterArgs', 'GetSubjectModeSchemaRegistryClusterArgsDict']] = None,
                     subject_name: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubjectModeResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `SubjectMode` describes a Subject Mode data source.

    ## Example Usage

    ### Option #1: Manage multiple Schema Registry clusters in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    purchase_v1 = confluentcloud.get_subject_mode(schema_registry_cluster={
            "id": essentials["id"],
        },
        rest_endpoint=essentials["restEndpoint"],
        subject_name="proto-purchase-value",
        credentials={
            "key": "<Schema Registry API Key for data.confluent_schema_registry_cluster.essentials>",
            "secret": "<Schema Registry API Secret for data.confluent_schema_registry_cluster.essentials>",
        })
    pulumi.export("mode", purchase_v1.mode)
    ```

    ### Option #2: Manage a single Schema Registry cluster in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    purchase_v1 = confluentcloud.get_subject_mode(subject_name="proto-purchase-value")
    pulumi.export("mode", purchase_v1.mode)
    ```


    :param builtins.str rest_endpoint: The REST endpoint of the Schema Registry cluster, for example, `https://psrc-00000.us-central1.gcp.confluent.cloud:443`).
    :param builtins.str subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`.
           
           > **Note:** A Schema Registry API key consists of a key and a secret. Schema Registry API keys are required to interact with Schema Registry clusters in Confluent Cloud. Each Schema Registry API key is valid for one specific Schema Registry cluster.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['restEndpoint'] = rest_endpoint
    __args__['schemaRegistryCluster'] = schema_registry_cluster
    __args__['subjectName'] = subject_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getSubjectMode:getSubjectMode', __args__, opts=opts, typ=GetSubjectModeResult).value

    return AwaitableGetSubjectModeResult(
        credentials=pulumi.get(__ret__, 'credentials'),
        id=pulumi.get(__ret__, 'id'),
        mode=pulumi.get(__ret__, 'mode'),
        rest_endpoint=pulumi.get(__ret__, 'rest_endpoint'),
        schema_registry_cluster=pulumi.get(__ret__, 'schema_registry_cluster'),
        subject_name=pulumi.get(__ret__, 'subject_name'))
def get_subject_mode_output(credentials: Optional[pulumi.Input[Optional[Union['GetSubjectModeCredentialsArgs', 'GetSubjectModeCredentialsArgsDict']]]] = None,
                            rest_endpoint: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                            schema_registry_cluster: Optional[pulumi.Input[Optional[Union['GetSubjectModeSchemaRegistryClusterArgs', 'GetSubjectModeSchemaRegistryClusterArgsDict']]]] = None,
                            subject_name: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubjectModeResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `SubjectMode` describes a Subject Mode data source.

    ## Example Usage

    ### Option #1: Manage multiple Schema Registry clusters in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    purchase_v1 = confluentcloud.get_subject_mode(schema_registry_cluster={
            "id": essentials["id"],
        },
        rest_endpoint=essentials["restEndpoint"],
        subject_name="proto-purchase-value",
        credentials={
            "key": "<Schema Registry API Key for data.confluent_schema_registry_cluster.essentials>",
            "secret": "<Schema Registry API Secret for data.confluent_schema_registry_cluster.essentials>",
        })
    pulumi.export("mode", purchase_v1.mode)
    ```

    ### Option #2: Manage a single Schema Registry cluster in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    purchase_v1 = confluentcloud.get_subject_mode(subject_name="proto-purchase-value")
    pulumi.export("mode", purchase_v1.mode)
    ```


    :param builtins.str rest_endpoint: The REST endpoint of the Schema Registry cluster, for example, `https://psrc-00000.us-central1.gcp.confluent.cloud:443`).
    :param builtins.str subject_name: The name of the subject (in other words, the namespace), representing the subject under which the schema will be registered, for example, `test-subject`.
           
           > **Note:** A Schema Registry API key consists of a key and a secret. Schema Registry API keys are required to interact with Schema Registry clusters in Confluent Cloud. Each Schema Registry API key is valid for one specific Schema Registry cluster.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['restEndpoint'] = rest_endpoint
    __args__['schemaRegistryCluster'] = schema_registry_cluster
    __args__['subjectName'] = subject_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getSubjectMode:getSubjectMode', __args__, opts=opts, typ=GetSubjectModeResult)
    return __ret__.apply(lambda __response__: GetSubjectModeResult(
        credentials=pulumi.get(__response__, 'credentials'),
        id=pulumi.get(__response__, 'id'),
        mode=pulumi.get(__response__, 'mode'),
        rest_endpoint=pulumi.get(__response__, 'rest_endpoint'),
        schema_registry_cluster=pulumi.get(__response__, 'schema_registry_cluster'),
        subject_name=pulumi.get(__response__, 'subject_name')))
