# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTableflowTopicResult',
    'AwaitableGetTableflowTopicResult',
    'get_tableflow_topic',
    'get_tableflow_topic_output',
]

@pulumi.output_type
class GetTableflowTopicResult:
    """
    A collection of values returned by getTableflowTopic.
    """
    def __init__(__self__, byob_aws=None, credentials=None, display_name=None, enable_compaction=None, enable_partitioning=None, environment=None, id=None, kafka_cluster=None, managed_storages=None, record_failure_strategy=None, retention_ms=None, suspended=None, table_formats=None):
        if byob_aws and not isinstance(byob_aws, list):
            raise TypeError("Expected argument 'byob_aws' to be a list")
        pulumi.set(__self__, "byob_aws", byob_aws)
        if credentials and not isinstance(credentials, dict):
            raise TypeError("Expected argument 'credentials' to be a dict")
        pulumi.set(__self__, "credentials", credentials)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enable_compaction and not isinstance(enable_compaction, bool):
            raise TypeError("Expected argument 'enable_compaction' to be a bool")
        pulumi.set(__self__, "enable_compaction", enable_compaction)
        if enable_partitioning and not isinstance(enable_partitioning, bool):
            raise TypeError("Expected argument 'enable_partitioning' to be a bool")
        pulumi.set(__self__, "enable_partitioning", enable_partitioning)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kafka_cluster and not isinstance(kafka_cluster, dict):
            raise TypeError("Expected argument 'kafka_cluster' to be a dict")
        pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if managed_storages and not isinstance(managed_storages, list):
            raise TypeError("Expected argument 'managed_storages' to be a list")
        pulumi.set(__self__, "managed_storages", managed_storages)
        if record_failure_strategy and not isinstance(record_failure_strategy, str):
            raise TypeError("Expected argument 'record_failure_strategy' to be a str")
        pulumi.set(__self__, "record_failure_strategy", record_failure_strategy)
        if retention_ms and not isinstance(retention_ms, str):
            raise TypeError("Expected argument 'retention_ms' to be a str")
        pulumi.set(__self__, "retention_ms", retention_ms)
        if suspended and not isinstance(suspended, bool):
            raise TypeError("Expected argument 'suspended' to be a bool")
        pulumi.set(__self__, "suspended", suspended)
        if table_formats and not isinstance(table_formats, list):
            raise TypeError("Expected argument 'table_formats' to be a list")
        pulumi.set(__self__, "table_formats", table_formats)

    @property
    @pulumi.getter(name="byobAws")
    def byob_aws(self) -> Sequence['outputs.GetTableflowTopicByobAwResult']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "byob_aws")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.GetTableflowTopicCredentialsResult']:
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableCompaction")
    def enable_compaction(self) -> builtins.bool:
        """
        (Optional Boolean) This flag determines whether to enable compaction for the Tableflow enabled topic.
        """
        return pulumi.get(self, "enable_compaction")

    @property
    @pulumi.getter(name="enablePartitioning")
    def enable_partitioning(self) -> builtins.bool:
        """
        (Optional Boolean) This flag determines whether to enable partitioning for the Tableflow enabled topic.
        """
        return pulumi.get(self, "enable_partitioning")

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.GetTableflowTopicEnvironmentResult':
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> 'outputs.GetTableflowTopicKafkaClusterResult':
        return pulumi.get(self, "kafka_cluster")

    @property
    @pulumi.getter(name="managedStorages")
    def managed_storages(self) -> Sequence['outputs.GetTableflowTopicManagedStorageResult']:
        """
        (Optional Configuration Block) The configuration of the Confluent managed bucket.
        """
        return pulumi.get(self, "managed_storages")

    @property
    @pulumi.getter(name="recordFailureStrategy")
    def record_failure_strategy(self) -> builtins.str:
        """
        (Optional String) The strategy to handle record failures in the Tableflow enabled topic during materialization. For `SKIP`, we skip the bad records and move to the next record. For `SUSPEND`, we suspend the materialization of the topic.
        """
        return pulumi.get(self, "record_failure_strategy")

    @property
    @pulumi.getter(name="retentionMs")
    def retention_ms(self) -> builtins.str:
        """
        (Optional String) The max age of snapshots (Iceberg) or versions (Delta) (snapshot/version expiration) to keep on the table in milliseconds for the Tableflow enabled topic.
        """
        return pulumi.get(self, "retention_ms")

    @property
    @pulumi.getter
    def suspended(self) -> builtins.bool:
        """
        (Optional Boolean) Indicates whether the Tableflow should be suspended.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter(name="tableFormats")
    def table_formats(self) -> Sequence[builtins.str]:
        """
        (Optional List) The supported table formats for the Tableflow-enabled topic.
        """
        return pulumi.get(self, "table_formats")


class AwaitableGetTableflowTopicResult(GetTableflowTopicResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableflowTopicResult(
            byob_aws=self.byob_aws,
            credentials=self.credentials,
            display_name=self.display_name,
            enable_compaction=self.enable_compaction,
            enable_partitioning=self.enable_partitioning,
            environment=self.environment,
            id=self.id,
            kafka_cluster=self.kafka_cluster,
            managed_storages=self.managed_storages,
            record_failure_strategy=self.record_failure_strategy,
            retention_ms=self.retention_ms,
            suspended=self.suspended,
            table_formats=self.table_formats)


def get_tableflow_topic(credentials: Optional[Union['GetTableflowTopicCredentialsArgs', 'GetTableflowTopicCredentialsArgsDict']] = None,
                        display_name: Optional[builtins.str] = None,
                        environment: Optional[Union['GetTableflowTopicEnvironmentArgs', 'GetTableflowTopicEnvironmentArgsDict']] = None,
                        kafka_cluster: Optional[Union['GetTableflowTopicKafkaClusterArgs', 'GetTableflowTopicKafkaClusterArgsDict']] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableflowTopicResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `TableflowTopic` describes a Tableflow Topic data source.

    ## Example Usage

    ### Option #1: Manage multiple Tableflow Topics in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_tableflow_topic(environment={
            "id": staging["id"],
        },
        kafka_cluster={
            "id": staging_confluent_kafka_cluster["id"],
        },
        display_name="tableflow-example",
        credentials={
            "key": env_admin_tableflow_api_key["id"],
            "secret": env_admin_tableflow_api_key["secret"],
        })
    pulumi.export("retention-ms", example.retention_ms)
    ```

    ### Option #2: Manage a single Tableflow Topic in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_tableflow_topic(display_name="tableflow-example")
    pulumi.export("retention-ms", example.retention_ms)
    ```


    :param builtins.str display_name: The name of the Tableflow Topic.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['displayName'] = display_name
    __args__['environment'] = environment
    __args__['kafkaCluster'] = kafka_cluster
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getTableflowTopic:getTableflowTopic', __args__, opts=opts, typ=GetTableflowTopicResult).value

    return AwaitableGetTableflowTopicResult(
        byob_aws=pulumi.get(__ret__, 'byob_aws'),
        credentials=pulumi.get(__ret__, 'credentials'),
        display_name=pulumi.get(__ret__, 'display_name'),
        enable_compaction=pulumi.get(__ret__, 'enable_compaction'),
        enable_partitioning=pulumi.get(__ret__, 'enable_partitioning'),
        environment=pulumi.get(__ret__, 'environment'),
        id=pulumi.get(__ret__, 'id'),
        kafka_cluster=pulumi.get(__ret__, 'kafka_cluster'),
        managed_storages=pulumi.get(__ret__, 'managed_storages'),
        record_failure_strategy=pulumi.get(__ret__, 'record_failure_strategy'),
        retention_ms=pulumi.get(__ret__, 'retention_ms'),
        suspended=pulumi.get(__ret__, 'suspended'),
        table_formats=pulumi.get(__ret__, 'table_formats'))
def get_tableflow_topic_output(credentials: Optional[pulumi.Input[Optional[Union['GetTableflowTopicCredentialsArgs', 'GetTableflowTopicCredentialsArgsDict']]]] = None,
                               display_name: Optional[pulumi.Input[builtins.str]] = None,
                               environment: Optional[pulumi.Input[Union['GetTableflowTopicEnvironmentArgs', 'GetTableflowTopicEnvironmentArgsDict']]] = None,
                               kafka_cluster: Optional[pulumi.Input[Union['GetTableflowTopicKafkaClusterArgs', 'GetTableflowTopicKafkaClusterArgsDict']]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTableflowTopicResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `TableflowTopic` describes a Tableflow Topic data source.

    ## Example Usage

    ### Option #1: Manage multiple Tableflow Topics in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_tableflow_topic(environment={
            "id": staging["id"],
        },
        kafka_cluster={
            "id": staging_confluent_kafka_cluster["id"],
        },
        display_name="tableflow-example",
        credentials={
            "key": env_admin_tableflow_api_key["id"],
            "secret": env_admin_tableflow_api_key["secret"],
        })
    pulumi.export("retention-ms", example.retention_ms)
    ```

    ### Option #2: Manage a single Tableflow Topic in the same Pulumi Stack

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_tableflow_topic(display_name="tableflow-example")
    pulumi.export("retention-ms", example.retention_ms)
    ```


    :param builtins.str display_name: The name of the Tableflow Topic.
    """
    __args__ = dict()
    __args__['credentials'] = credentials
    __args__['displayName'] = display_name
    __args__['environment'] = environment
    __args__['kafkaCluster'] = kafka_cluster
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getTableflowTopic:getTableflowTopic', __args__, opts=opts, typ=GetTableflowTopicResult)
    return __ret__.apply(lambda __response__: GetTableflowTopicResult(
        byob_aws=pulumi.get(__response__, 'byob_aws'),
        credentials=pulumi.get(__response__, 'credentials'),
        display_name=pulumi.get(__response__, 'display_name'),
        enable_compaction=pulumi.get(__response__, 'enable_compaction'),
        enable_partitioning=pulumi.get(__response__, 'enable_partitioning'),
        environment=pulumi.get(__response__, 'environment'),
        id=pulumi.get(__response__, 'id'),
        kafka_cluster=pulumi.get(__response__, 'kafka_cluster'),
        managed_storages=pulumi.get(__response__, 'managed_storages'),
        record_failure_strategy=pulumi.get(__response__, 'record_failure_strategy'),
        retention_ms=pulumi.get(__response__, 'retention_ms'),
        suspended=pulumi.get(__response__, 'suspended'),
        table_formats=pulumi.get(__response__, 'table_formats')))
