# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IdentityPoolArgs', 'IdentityPool']

@pulumi.input_type
class IdentityPoolArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 filter: pulumi.Input[builtins.str],
                 identity_claim: pulumi.Input[builtins.str],
                 identity_provider: pulumi.Input['IdentityPoolIdentityProviderArgs']):
        """
        The set of arguments for constructing a IdentityPool resource.
        :param pulumi.Input[builtins.str] description: A description for the Identity Pool.
        :param pulumi.Input[builtins.str] display_name: A human-readable name for the Identity Pool.
        :param pulumi.Input[builtins.str] filter: A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#supported-common-expression-language-cel-filters) that specifies which identities can authenticate using your identity pool (see [Set identity pool filters](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#set-identity-pool-filters) for more details).
        :param pulumi.Input[builtins.str] identity_claim: The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from (see [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) for more details). This appears in the audit log records, showing, for example, that "identity Z used identity pool X to access topic A".
        :param pulumi.Input['IdentityPoolIdentityProviderArgs'] identity_provider: Identity Provider objects represent external OAuth/OpenID Connect providers within Confluent Cloud.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "identity_claim", identity_claim)
        pulumi.set(__self__, "identity_provider", identity_provider)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        A description for the Identity Pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        A human-readable name for the Identity Pool.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Input[builtins.str]:
        """
        A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#supported-common-expression-language-cel-filters) that specifies which identities can authenticate using your identity pool (see [Set identity pool filters](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#set-identity-pool-filters) for more details).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="identityClaim")
    def identity_claim(self) -> pulumi.Input[builtins.str]:
        """
        The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from (see [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) for more details). This appears in the audit log records, showing, for example, that "identity Z used identity pool X to access topic A".
        """
        return pulumi.get(self, "identity_claim")

    @identity_claim.setter
    def identity_claim(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "identity_claim", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> pulumi.Input['IdentityPoolIdentityProviderArgs']:
        """
        Identity Provider objects represent external OAuth/OpenID Connect providers within Confluent Cloud.
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: pulumi.Input['IdentityPoolIdentityProviderArgs']):
        pulumi.set(self, "identity_provider", value)


@pulumi.input_type
class _IdentityPoolState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 identity_claim: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider: Optional[pulumi.Input['IdentityPoolIdentityProviderArgs']] = None):
        """
        Input properties used for looking up and filtering IdentityPool resources.
        :param pulumi.Input[builtins.str] description: A description for the Identity Pool.
        :param pulumi.Input[builtins.str] display_name: A human-readable name for the Identity Pool.
        :param pulumi.Input[builtins.str] filter: A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#supported-common-expression-language-cel-filters) that specifies which identities can authenticate using your identity pool (see [Set identity pool filters](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#set-identity-pool-filters) for more details).
        :param pulumi.Input[builtins.str] identity_claim: The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from (see [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) for more details). This appears in the audit log records, showing, for example, that "identity Z used identity pool X to access topic A".
        :param pulumi.Input['IdentityPoolIdentityProviderArgs'] identity_provider: Identity Provider objects represent external OAuth/OpenID Connect providers within Confluent Cloud.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if identity_claim is not None:
            pulumi.set(__self__, "identity_claim", identity_claim)
        if identity_provider is not None:
            pulumi.set(__self__, "identity_provider", identity_provider)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description for the Identity Pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable name for the Identity Pool.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#supported-common-expression-language-cel-filters) that specifies which identities can authenticate using your identity pool (see [Set identity pool filters](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#set-identity-pool-filters) for more details).
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter(name="identityClaim")
    def identity_claim(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from (see [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) for more details). This appears in the audit log records, showing, for example, that "identity Z used identity pool X to access topic A".
        """
        return pulumi.get(self, "identity_claim")

    @identity_claim.setter
    def identity_claim(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_claim", value)

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> Optional[pulumi.Input['IdentityPoolIdentityProviderArgs']]:
        """
        Identity Provider objects represent external OAuth/OpenID Connect providers within Confluent Cloud.
        """
        return pulumi.get(self, "identity_provider")

    @identity_provider.setter
    def identity_provider(self, value: Optional[pulumi.Input['IdentityPoolIdentityProviderArgs']]):
        pulumi.set(self, "identity_provider", value)


@pulumi.type_token("confluentcloud:index/identityPool:IdentityPool")
class IdentityPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 identity_claim: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider: Optional[pulumi.Input[Union['IdentityPoolIdentityProviderArgs', 'IdentityPoolIdentityProviderArgsDict']]] = None,
                 __props__=None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `IdentityPool` provides an Identity Pool resource that enables creating, editing, and deleting identity pools on Confluent Cloud.

        ## Example Usage

        ### Example Identity Pool to be used with Azure AD

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        azure = confluentcloud.IdentityProvider("azure",
            display_name="My OIDC Provider: Azure AD",
            description="My description",
            issuer="https://login.microsoftonline.com/{tenant_id}/v2.0",
            jwks_uri="https://login.microsoftonline.com/common/discovery/v2.0/keys")
        example = confluentcloud.IdentityPool("example",
            identity_provider={
                "id": azure.id,
            },
            display_name="My Identity Pool",
            description="Prod Access to Kafka clusters to Release Engineering",
            identity_claim="claims.sub",
            filter="claims.aud==\\"confluent\\" && claims.group!=\\"invalid_group\\"")
        ```

        ### Example Identity Pool to be used with Okta

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        okta = confluentcloud.IdentityProvider("okta",
            display_name="My OIDC Provider: Okta",
            description="My description",
            issuer="https://mycompany.okta.com/oauth2/default",
            jwks_uri="https://mycompany.okta.com/oauth2/default/v1/keys")
        example = confluentcloud.IdentityPool("example",
            identity_provider={
                "id": okta.id,
            },
            display_name="My Identity Pool",
            description="Prod Access to Kafka clusters to Release Engineering",
            identity_claim="claims.sub",
            filter="claims.aud==\\"confluent\\" && claims.group!=\\"invalid_group\\"")
        ```

        ## External Documentation

        * [Use identity pools with your OAuth provider](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html).

        ## Import

        You can import an Identity Pool by using Identity Provider ID and Identity Pool ID, in the format `<Identity Provider ID>/<Identity Pool ID>`. The following example shows how to import an Identity Pool:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/identityPool:IdentityPool example op-abc123/pool-xyz456
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description for the Identity Pool.
        :param pulumi.Input[builtins.str] display_name: A human-readable name for the Identity Pool.
        :param pulumi.Input[builtins.str] filter: A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#supported-common-expression-language-cel-filters) that specifies which identities can authenticate using your identity pool (see [Set identity pool filters](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#set-identity-pool-filters) for more details).
        :param pulumi.Input[builtins.str] identity_claim: The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from (see [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) for more details). This appears in the audit log records, showing, for example, that "identity Z used identity pool X to access topic A".
        :param pulumi.Input[Union['IdentityPoolIdentityProviderArgs', 'IdentityPoolIdentityProviderArgsDict']] identity_provider: Identity Provider objects represent external OAuth/OpenID Connect providers within Confluent Cloud.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `IdentityPool` provides an Identity Pool resource that enables creating, editing, and deleting identity pools on Confluent Cloud.

        ## Example Usage

        ### Example Identity Pool to be used with Azure AD

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        azure = confluentcloud.IdentityProvider("azure",
            display_name="My OIDC Provider: Azure AD",
            description="My description",
            issuer="https://login.microsoftonline.com/{tenant_id}/v2.0",
            jwks_uri="https://login.microsoftonline.com/common/discovery/v2.0/keys")
        example = confluentcloud.IdentityPool("example",
            identity_provider={
                "id": azure.id,
            },
            display_name="My Identity Pool",
            description="Prod Access to Kafka clusters to Release Engineering",
            identity_claim="claims.sub",
            filter="claims.aud==\\"confluent\\" && claims.group!=\\"invalid_group\\"")
        ```

        ### Example Identity Pool to be used with Okta

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        okta = confluentcloud.IdentityProvider("okta",
            display_name="My OIDC Provider: Okta",
            description="My description",
            issuer="https://mycompany.okta.com/oauth2/default",
            jwks_uri="https://mycompany.okta.com/oauth2/default/v1/keys")
        example = confluentcloud.IdentityPool("example",
            identity_provider={
                "id": okta.id,
            },
            display_name="My Identity Pool",
            description="Prod Access to Kafka clusters to Release Engineering",
            identity_claim="claims.sub",
            filter="claims.aud==\\"confluent\\" && claims.group!=\\"invalid_group\\"")
        ```

        ## External Documentation

        * [Use identity pools with your OAuth provider](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html).

        ## Import

        You can import an Identity Pool by using Identity Provider ID and Identity Pool ID, in the format `<Identity Provider ID>/<Identity Pool ID>`. The following example shows how to import an Identity Pool:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/identityPool:IdentityPool example op-abc123/pool-xyz456
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param IdentityPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 filter: Optional[pulumi.Input[builtins.str]] = None,
                 identity_claim: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider: Optional[pulumi.Input[Union['IdentityPoolIdentityProviderArgs', 'IdentityPoolIdentityProviderArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityPoolArgs.__new__(IdentityPoolArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if filter is None and not opts.urn:
                raise TypeError("Missing required property 'filter'")
            __props__.__dict__["filter"] = filter
            if identity_claim is None and not opts.urn:
                raise TypeError("Missing required property 'identity_claim'")
            __props__.__dict__["identity_claim"] = identity_claim
            if identity_provider is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider'")
            __props__.__dict__["identity_provider"] = identity_provider
        super(IdentityPool, __self__).__init__(
            'confluentcloud:index/identityPool:IdentityPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            filter: Optional[pulumi.Input[builtins.str]] = None,
            identity_claim: Optional[pulumi.Input[builtins.str]] = None,
            identity_provider: Optional[pulumi.Input[Union['IdentityPoolIdentityProviderArgs', 'IdentityPoolIdentityProviderArgsDict']]] = None) -> 'IdentityPool':
        """
        Get an existing IdentityPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description for the Identity Pool.
        :param pulumi.Input[builtins.str] display_name: A human-readable name for the Identity Pool.
        :param pulumi.Input[builtins.str] filter: A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#supported-common-expression-language-cel-filters) that specifies which identities can authenticate using your identity pool (see [Set identity pool filters](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#set-identity-pool-filters) for more details).
        :param pulumi.Input[builtins.str] identity_claim: The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from (see [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) for more details). This appears in the audit log records, showing, for example, that "identity Z used identity pool X to access topic A".
        :param pulumi.Input[Union['IdentityPoolIdentityProviderArgs', 'IdentityPoolIdentityProviderArgsDict']] identity_provider: Identity Provider objects represent external OAuth/OpenID Connect providers within Confluent Cloud.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityPoolState.__new__(_IdentityPoolState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["filter"] = filter
        __props__.__dict__["identity_claim"] = identity_claim
        __props__.__dict__["identity_provider"] = identity_provider
        return IdentityPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A description for the Identity Pool.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        A human-readable name for the Identity Pool.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[builtins.str]:
        """
        A filter expression in [Supported Common Expression Language (CEL)](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#supported-common-expression-language-cel-filters) that specifies which identities can authenticate using your identity pool (see [Set identity pool filters](https://docs.confluent.io/cloud/current/access-management/authenticate/oauth/identity-pools.html#set-identity-pool-filters) for more details).
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="identityClaim")
    def identity_claim(self) -> pulumi.Output[builtins.str]:
        """
        The JSON Web Token (JWT) claim to extract the authenticating identity to Confluent resources from (see [Registered Claim Names](https://datatracker.ietf.org/doc/html/rfc7519#section-4.1) for more details). This appears in the audit log records, showing, for example, that "identity Z used identity pool X to access topic A".
        """
        return pulumi.get(self, "identity_claim")

    @property
    @pulumi.getter(name="identityProvider")
    def identity_provider(self) -> pulumi.Output['outputs.IdentityPoolIdentityProvider']:
        """
        Identity Provider objects represent external OAuth/OpenID Connect providers within Confluent Cloud.
        """
        return pulumi.get(self, "identity_provider")

