# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PeeringArgs', 'Peering']

@pulumi.input_type
class PeeringArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input['PeeringEnvironmentArgs'],
                 network: pulumi.Input['PeeringNetworkArgs'],
                 aws: Optional[pulumi.Input['PeeringAwsArgs']] = None,
                 azure: Optional[pulumi.Input['PeeringAzureArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 gcp: Optional[pulumi.Input['PeeringGcpArgs']] = None):
        """
        The set of arguments for constructing a Peering resource.
        :param pulumi.Input['PeeringEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input['PeeringNetworkArgs'] network: Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider
               accounts.
        :param pulumi.Input[builtins.str] display_name: The name of the Peering.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "network", network)
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input['PeeringEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['PeeringEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input['PeeringNetworkArgs']:
        """
        Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider
        accounts.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input['PeeringNetworkArgs']):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['PeeringAwsArgs']]:
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['PeeringAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['PeeringAzureArgs']]:
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['PeeringAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Peering.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['PeeringGcpArgs']]:
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['PeeringGcpArgs']]):
        pulumi.set(self, "gcp", value)


@pulumi.input_type
class _PeeringState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input['PeeringAwsArgs']] = None,
                 azure: Optional[pulumi.Input['PeeringAzureArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input['PeeringEnvironmentArgs']] = None,
                 gcp: Optional[pulumi.Input['PeeringGcpArgs']] = None,
                 network: Optional[pulumi.Input['PeeringNetworkArgs']] = None):
        """
        Input properties used for looking up and filtering Peering resources.
        :param pulumi.Input[builtins.str] display_name: The name of the Peering.
        :param pulumi.Input['PeeringEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input['PeeringNetworkArgs'] network: Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider
               accounts.
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azure is not None:
            pulumi.set(__self__, "azure", azure)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if gcp is not None:
            pulumi.set(__self__, "gcp", gcp)
        if network is not None:
            pulumi.set(__self__, "network", network)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input['PeeringAwsArgs']]:
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input['PeeringAwsArgs']]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azure(self) -> Optional[pulumi.Input['PeeringAzureArgs']]:
        return pulumi.get(self, "azure")

    @azure.setter
    def azure(self, value: Optional[pulumi.Input['PeeringAzureArgs']]):
        pulumi.set(self, "azure", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Peering.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['PeeringEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['PeeringEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def gcp(self) -> Optional[pulumi.Input['PeeringGcpArgs']]:
        return pulumi.get(self, "gcp")

    @gcp.setter
    def gcp(self, value: Optional[pulumi.Input['PeeringGcpArgs']]):
        pulumi.set(self, "gcp", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['PeeringNetworkArgs']]:
        """
        Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider
        accounts.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['PeeringNetworkArgs']]):
        pulumi.set(self, "network", value)


@pulumi.type_token("confluentcloud:index/peering:Peering")
class Peering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['PeeringAwsArgs', 'PeeringAwsArgsDict']]] = None,
                 azure: Optional[pulumi.Input[Union['PeeringAzureArgs', 'PeeringAzureArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['PeeringEnvironmentArgs', 'PeeringEnvironmentArgsDict']]] = None,
                 gcp: Optional[pulumi.Input[Union['PeeringGcpArgs', 'PeeringGcpArgsDict']]] = None,
                 network: Optional[pulumi.Input[Union['PeeringNetworkArgs', 'PeeringNetworkArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Example Peering on AWS

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        aws_peering = confluentcloud.Network("aws-peering",
            display_name="AWS Peering Network",
            cloud="AWS",
            region="us-east-2",
            cidr="10.10.0.0/16",
            connection_types=["PEERING"],
            environment={
                "id": development.id,
            })
        aws = confluentcloud.Peering("aws",
            display_name="AWS Peering",
            aws={
                "account": "012345678901",
                "vpc": "vpc-abcdef0123456789a",
                "routes": ["172.31.0.0/16"],
                "customer_region": "us-east-2",
            },
            environment={
                "id": development.id,
            },
            network={
                "id": aws_peering.id,
            })
        ```

        ### Example Peering on Azure

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        azure_peering = confluentcloud.Network("azure-peering",
            display_name="Azure Peering Network",
            cloud="AZURE",
            region="centralus",
            cidr="10.10.0.0/16",
            connection_types=["PEERING"],
            environment={
                "id": development.id,
            })
        azure = confluentcloud.Peering("azure",
            display_name="Azure Peering",
            azure={
                "tenant": "1111tttt-1111-1111-1111-111111tttttt",
                "vnet": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/my-rg/providers/Microsoft.Network/virtualNetworks/my-vnet",
                "customer_region": "centralus",
            },
            environment={
                "id": development.id,
            },
            network={
                "id": azure_peering.id,
            })
        ```

        ### Example Peering on GCP

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        gcp_peering = confluentcloud.Network("gcp-peering",
            display_name="GCP Peering Network",
            cloud="GCP",
            region="us-west4",
            cidr="10.10.0.0/16",
            connection_types=["PEERING"],
            environment={
                "id": development.id,
            })
        gcp = confluentcloud.Peering("gcp",
            display_name="GCP Peering",
            gcp={
                "project": "temp-gear-123456",
                "vpc_network": "customer-test-vpc-network",
            },
            environment={
                "id": development.id,
            },
            network={
                "id": gcp_peering.id,
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Peering` resource:
          * dedicated-vnet-peering-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vnet-peering-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-transit-gateway-attachment-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using RBAC
          * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs

        ## Import

        You can import a Peering by using Environment ID and Peering ID, in the format `<Environment ID>/<Peering ID>`. The following example shows how to import a Peering:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/peering:Peering my_peer env-abc123/peer-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: The name of the Peering.
        :param pulumi.Input[Union['PeeringEnvironmentArgs', 'PeeringEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Union['PeeringNetworkArgs', 'PeeringNetworkArgsDict']] network: Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider
               accounts.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Example Peering on AWS

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        aws_peering = confluentcloud.Network("aws-peering",
            display_name="AWS Peering Network",
            cloud="AWS",
            region="us-east-2",
            cidr="10.10.0.0/16",
            connection_types=["PEERING"],
            environment={
                "id": development.id,
            })
        aws = confluentcloud.Peering("aws",
            display_name="AWS Peering",
            aws={
                "account": "012345678901",
                "vpc": "vpc-abcdef0123456789a",
                "routes": ["172.31.0.0/16"],
                "customer_region": "us-east-2",
            },
            environment={
                "id": development.id,
            },
            network={
                "id": aws_peering.id,
            })
        ```

        ### Example Peering on Azure

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        azure_peering = confluentcloud.Network("azure-peering",
            display_name="Azure Peering Network",
            cloud="AZURE",
            region="centralus",
            cidr="10.10.0.0/16",
            connection_types=["PEERING"],
            environment={
                "id": development.id,
            })
        azure = confluentcloud.Peering("azure",
            display_name="Azure Peering",
            azure={
                "tenant": "1111tttt-1111-1111-1111-111111tttttt",
                "vnet": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/my-rg/providers/Microsoft.Network/virtualNetworks/my-vnet",
                "customer_region": "centralus",
            },
            environment={
                "id": development.id,
            },
            network={
                "id": azure_peering.id,
            })
        ```

        ### Example Peering on GCP

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        gcp_peering = confluentcloud.Network("gcp-peering",
            display_name="GCP Peering Network",
            cloud="GCP",
            region="us-west4",
            cidr="10.10.0.0/16",
            connection_types=["PEERING"],
            environment={
                "id": development.id,
            })
        gcp = confluentcloud.Peering("gcp",
            display_name="GCP Peering",
            gcp={
                "project": "temp-gear-123456",
                "vpc_network": "customer-test-vpc-network",
            },
            environment={
                "id": development.id,
            },
            network={
                "id": gcp_peering.id,
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Peering` resource:
          * dedicated-vnet-peering-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vnet-peering-azure-kafka-rbac: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-vpc-peering-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using RBAC
          * dedicated-transit-gateway-attachment-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using RBAC
          * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs

        ## Import

        You can import a Peering by using Environment ID and Peering ID, in the format `<Environment ID>/<Peering ID>`. The following example shows how to import a Peering:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/peering:Peering my_peer env-abc123/peer-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param PeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Union['PeeringAwsArgs', 'PeeringAwsArgsDict']]] = None,
                 azure: Optional[pulumi.Input[Union['PeeringAzureArgs', 'PeeringAzureArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['PeeringEnvironmentArgs', 'PeeringEnvironmentArgsDict']]] = None,
                 gcp: Optional[pulumi.Input[Union['PeeringGcpArgs', 'PeeringGcpArgsDict']]] = None,
                 network: Optional[pulumi.Input[Union['PeeringNetworkArgs', 'PeeringNetworkArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeeringArgs.__new__(PeeringArgs)

            __props__.__dict__["aws"] = aws
            __props__.__dict__["azure"] = azure
            __props__.__dict__["display_name"] = display_name
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["gcp"] = gcp
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
        super(Peering, __self__).__init__(
            'confluentcloud:index/peering:Peering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[Union['PeeringAwsArgs', 'PeeringAwsArgsDict']]] = None,
            azure: Optional[pulumi.Input[Union['PeeringAzureArgs', 'PeeringAzureArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['PeeringEnvironmentArgs', 'PeeringEnvironmentArgsDict']]] = None,
            gcp: Optional[pulumi.Input[Union['PeeringGcpArgs', 'PeeringGcpArgsDict']]] = None,
            network: Optional[pulumi.Input[Union['PeeringNetworkArgs', 'PeeringNetworkArgsDict']]] = None) -> 'Peering':
        """
        Get an existing Peering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] display_name: The name of the Peering.
        :param pulumi.Input[Union['PeeringEnvironmentArgs', 'PeeringEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Union['PeeringNetworkArgs', 'PeeringNetworkArgsDict']] network: Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider
               accounts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeeringState.__new__(_PeeringState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["azure"] = azure
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment"] = environment
        __props__.__dict__["gcp"] = gcp
        __props__.__dict__["network"] = network
        return Peering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional['outputs.PeeringAws']]:
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def azure(self) -> pulumi.Output[Optional['outputs.PeeringAzure']]:
        return pulumi.get(self, "azure")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Peering.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.PeeringEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def gcp(self) -> pulumi.Output[Optional['outputs.PeeringGcp']]:
        return pulumi.get(self, "gcp")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output['outputs.PeeringNetwork']:
        """
        Network represents a network (VPC) in Confluent Cloud. All Networks exist within Confluent-managed cloud provider
        accounts.
        """
        return pulumi.get(self, "network")

