# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PluginArgs', 'Plugin']

@pulumi.input_type
class PluginArgs:
    def __init__(__self__, *,
                 cloud: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 environment: pulumi.Input['PluginEnvironmentArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_language: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Plugin resource.
        :param pulumi.Input[builtins.str] cloud: Cloud provider where the Custom Connector Plugin archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[builtins.str] display_name: The name of the Plugin.
        :param pulumi.Input['PluginEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[builtins.str] description: The description of the Plugin.
        :param pulumi.Input[builtins.str] runtime_language: (Optional String) Runtime language of the plugin.
        """
        pulumi.set(__self__, "cloud", cloud)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment", environment)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if runtime_language is not None:
            pulumi.set(__self__, "runtime_language", runtime_language)

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Input[builtins.str]:
        """
        Cloud provider where the Custom Connector Plugin archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the Plugin.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input['PluginEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['PluginEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Plugin.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="runtimeLanguage")
    def runtime_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional String) Runtime language of the plugin.
        """
        return pulumi.get(self, "runtime_language")

    @runtime_language.setter
    def runtime_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_language", value)


@pulumi.input_type
class _PluginState:
    def __init__(__self__, *,
                 api_version: Optional[pulumi.Input[builtins.str]] = None,
                 cloud: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input['PluginEnvironmentArgs']] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_language: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Plugin resources.
        :param pulumi.Input[builtins.str] api_version: (Required String) The API Version of the schema version of the plugin, for example, `ccpm/v1`.
        :param pulumi.Input[builtins.str] cloud: Cloud provider where the Custom Connector Plugin archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[builtins.str] description: The description of the Plugin.
        :param pulumi.Input[builtins.str] display_name: The name of the Plugin.
        :param pulumi.Input['PluginEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[builtins.str] kind: (Required String) The kind of the Plugin, for example, `CustomConnectPlugin`.
        :param pulumi.Input[builtins.str] runtime_language: (Optional String) Runtime language of the plugin.
        """
        if api_version is not None:
            pulumi.set(__self__, "api_version", api_version)
        if cloud is not None:
            pulumi.set(__self__, "cloud", cloud)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if runtime_language is not None:
            pulumi.set(__self__, "runtime_language", runtime_language)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required String) The API Version of the schema version of the plugin, for example, `ccpm/v1`.
        """
        return pulumi.get(self, "api_version")

    @api_version.setter
    def api_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_version", value)

    @property
    @pulumi.getter
    def cloud(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cloud provider where the Custom Connector Plugin archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @cloud.setter
    def cloud(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Plugin.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Plugin.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['PluginEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['PluginEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Required String) The kind of the Plugin, for example, `CustomConnectPlugin`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="runtimeLanguage")
    def runtime_language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional String) Runtime language of the plugin.
        """
        return pulumi.get(self, "runtime_language")

    @runtime_language.setter
    def runtime_language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_language", value)


@pulumi.type_token("confluentcloud:index/plugin:Plugin")
class Plugin(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['PluginEnvironmentArgs', 'PluginEnvironmentArgsDict']]] = None,
                 runtime_language: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        You can import a Custom Connector Plugin by using a Plugin ID, in the format `<Environment ID/Custom Connector Plugin ID>`. The following example shows how to import a Plugin:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/plugin:Plugin main env-123/ccpm-abc123xyz
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloud: Cloud provider where the Custom Connector Plugin archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[builtins.str] description: The description of the Plugin.
        :param pulumi.Input[builtins.str] display_name: The name of the Plugin.
        :param pulumi.Input[Union['PluginEnvironmentArgs', 'PluginEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[builtins.str] runtime_language: (Optional String) Runtime language of the plugin.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluginArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        You can import a Custom Connector Plugin by using a Plugin ID, in the format `<Environment ID/Custom Connector Plugin ID>`. The following example shows how to import a Plugin:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/plugin:Plugin main env-123/ccpm-abc123xyz
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param PluginArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluginArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['PluginEnvironmentArgs', 'PluginEnvironmentArgsDict']]] = None,
                 runtime_language: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluginArgs.__new__(PluginArgs)

            if cloud is None and not opts.urn:
                raise TypeError("Missing required property 'cloud'")
            __props__.__dict__["cloud"] = cloud
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["runtime_language"] = runtime_language
            __props__.__dict__["api_version"] = None
            __props__.__dict__["kind"] = None
        super(Plugin, __self__).__init__(
            'confluentcloud:index/plugin:Plugin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_version: Optional[pulumi.Input[builtins.str]] = None,
            cloud: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['PluginEnvironmentArgs', 'PluginEnvironmentArgsDict']]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            runtime_language: Optional[pulumi.Input[builtins.str]] = None) -> 'Plugin':
        """
        Get an existing Plugin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] api_version: (Required String) The API Version of the schema version of the plugin, for example, `ccpm/v1`.
        :param pulumi.Input[builtins.str] cloud: Cloud provider where the Custom Connector Plugin archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        :param pulumi.Input[builtins.str] description: The description of the Plugin.
        :param pulumi.Input[builtins.str] display_name: The name of the Plugin.
        :param pulumi.Input[Union['PluginEnvironmentArgs', 'PluginEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[builtins.str] kind: (Required String) The kind of the Plugin, for example, `CustomConnectPlugin`.
        :param pulumi.Input[builtins.str] runtime_language: (Optional String) Runtime language of the plugin.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluginState.__new__(_PluginState)

        __props__.__dict__["api_version"] = api_version
        __props__.__dict__["cloud"] = cloud
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment"] = environment
        __props__.__dict__["kind"] = kind
        __props__.__dict__["runtime_language"] = runtime_language
        return Plugin(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> pulumi.Output[builtins.str]:
        """
        (Required String) The API Version of the schema version of the plugin, for example, `ccpm/v1`.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter
    def cloud(self) -> pulumi.Output[builtins.str]:
        """
        Cloud provider where the Custom Connector Plugin archive is uploaded. Accepted values are: `AWS`, `AZURE`, `GCP`.
        """
        return pulumi.get(self, "cloud")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Plugin.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Plugin.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.PluginEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        (Required String) The kind of the Plugin, for example, `CustomConnectPlugin`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="runtimeLanguage")
    def runtime_language(self) -> pulumi.Output[builtins.str]:
        """
        (Optional String) Runtime language of the plugin.
        """
        return pulumi.get(self, "runtime_language")

