# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'ConfigPart',
    'GetConfigPartResult',
]

@pulumi.output_type
class ConfigPart(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"
        elif key == "mergeType":
            suggest = "merge_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigPart. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigPart.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigPart.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: _builtins.str,
                 content_type: Optional[_builtins.str] = None,
                 filename: Optional[_builtins.str] = None,
                 merge_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: Body content for the part.
        :param _builtins.str content_type: A MIME-style content type to report in the header for the part. Defaults to `text/plain`
        :param _builtins.str filename: A filename to report in the header for the part.
        :param _builtins.str merge_type: A value for the `X-Merge-Type` header of the part, to control [cloud-init merging behavior](https://cloudinit.readthedocs.io/en/latest/reference/merging.html).
        """
        pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if merge_type is not None:
            pulumi.set(__self__, "merge_type", merge_type)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Body content for the part.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        A MIME-style content type to report in the header for the part. Defaults to `text/plain`
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[_builtins.str]:
        """
        A filename to report in the header for the part.
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> Optional[_builtins.str]:
        """
        A value for the `X-Merge-Type` header of the part, to control [cloud-init merging behavior](https://cloudinit.readthedocs.io/en/latest/reference/merging.html).
        """
        return pulumi.get(self, "merge_type")


@pulumi.output_type
class GetConfigPartResult(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 content_type: Optional[_builtins.str] = None,
                 filename: Optional[_builtins.str] = None,
                 merge_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str content: Body content for the part.
        :param _builtins.str content_type: A MIME-style content type to report in the header for the part. Defaults to `text/plain`
        :param _builtins.str filename: A filename to report in the header for the part.
        :param _builtins.str merge_type: A value for the `X-Merge-Type` header of the part, to control [cloud-init merging behavior](https://cloudinit.readthedocs.io/en/latest/reference/merging.html).
        """
        pulumi.set(__self__, "content", content)
        if content_type is None:
            content_type = 'text/plain'
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if merge_type is not None:
            pulumi.set(__self__, "merge_type", merge_type)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Body content for the part.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[_builtins.str]:
        """
        A MIME-style content type to report in the header for the part. Defaults to `text/plain`
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def filename(self) -> Optional[_builtins.str]:
        """
        A filename to report in the header for the part.
        """
        return pulumi.get(self, "filename")

    @_builtins.property
    @pulumi.getter(name="mergeType")
    def merge_type(self) -> Optional[_builtins.str]:
        """
        A value for the `X-Merge-Type` header of the part, to control [cloud-init merging behavior](https://cloudinit.readthedocs.io/en/latest/reference/merging.html).
        """
        return pulumi.get(self, "merge_type")


