"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerConfigSecret = exports.TlsSecret = exports.ServiceAccountTokenSecret = exports.SshAuthSecret = exports.BasicAuthSecret = exports.Secret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const base = require("./base");
const k8s = require("./imports/k8s");
class ImportedSecret extends constructs_1.Construct {
    constructor(scope, id, name) {
        super(scope, id);
        this._name = name;
    }
    get name() {
        return this._name;
    }
    get apiVersion() {
        return k8s.KubeSecret.GVK.apiVersion;
    }
    get apiGroup() {
        return '';
    }
    get kind() {
        return k8s.KubeSecret.GVK.kind;
    }
}
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.resourceType = 'secrets';
        this.stringData = props.stringData ?? {};
        this.immutable = props.immutable ?? false;
        this.apiObject = new k8s.KubeSecret(this, 'Resource', {
            metadata: props.metadata,
            type: props.type,
            stringData: this.stringData,
            immutable: this.immutable,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     */
    static fromSecretName(scope, id, name) {
        return new ImportedSecret(scope, id, name);
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
}
exports.Secret = Secret;
_a = JSII_RTTI_SYMBOL_1;
Secret[_a] = { fqn: "cdk8s-plus-22.Secret", version: "2.0.0-rc.132" };
/**
 * Create a secret for basic authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret
 */
class BasicAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/basic-auth',
            stringData: {
                username: props.username,
                password: props.password,
            },
            immutable: props.immutable,
        });
    }
}
exports.BasicAuthSecret = BasicAuthSecret;
_b = JSII_RTTI_SYMBOL_1;
BasicAuthSecret[_b] = { fqn: "cdk8s-plus-22.BasicAuthSecret", version: "2.0.0-rc.132" };
/**
 * Create a secret for ssh authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#ssh-authentication-secrets
 */
class SshAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/ssh-auth',
            stringData: {
                'ssh-privatekey': props.sshPrivateKey,
            },
            immutable: props.immutable,
        });
    }
}
exports.SshAuthSecret = SshAuthSecret;
_c = JSII_RTTI_SYMBOL_1;
SshAuthSecret[_c] = { fqn: "cdk8s-plus-22.SshAuthSecret", version: "2.0.0-rc.132" };
/**
 * Create a secret for a service account token.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#service-account-token-secrets
 */
class ServiceAccountTokenSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/service-account-token',
            metadata: {
                annotations: {
                    'kubernetes.io/service-account.name': props.serviceAccount.name,
                },
            },
            immutable: props.immutable,
        });
    }
}
exports.ServiceAccountTokenSecret = ServiceAccountTokenSecret;
_d = JSII_RTTI_SYMBOL_1;
ServiceAccountTokenSecret[_d] = { fqn: "cdk8s-plus-22.ServiceAccountTokenSecret", version: "2.0.0-rc.132" };
/**
 * Create a secret for storing a TLS certificate and its associated key.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets
 */
class TlsSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/tls',
            stringData: {
                'tls.crt': props.tlsCert,
                'tls.key': props.tlsKey,
            },
            immutable: props.immutable,
        });
    }
}
exports.TlsSecret = TlsSecret;
_e = JSII_RTTI_SYMBOL_1;
TlsSecret[_e] = { fqn: "cdk8s-plus-22.TlsSecret", version: "2.0.0-rc.132" };
/**
 * Create a secret for storing credentials for accessing a container image
 * registry.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
 */
class DockerConfigSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/dockerconfigjson',
            stringData: {
                '.dockerconfigjson': JSON.stringify(props.data),
            },
            immutable: props.immutable,
        });
    }
}
exports.DockerConfigSecret = DockerConfigSecret;
_f = JSII_RTTI_SYMBOL_1;
DockerConfigSecret[_f] = { fqn: "cdk8s-plus-22.DockerConfigSecret", version: "2.0.0-rc.132" };
//# sourceMappingURL=data:application/json;base64,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