#!/usr/bin/env python
"""Django's command-line utility for administrative tasks."""
import logging
import os
import sys

from django.db.migrations import writer

if len(sys.argv) > 1 and sys.argv[1] == 'test':
    logging.disable(logging.WARNING)


writer.MIGRATION_HEADER_TEMPLATE = """\
# Generated by Django %(version)s on %(timestamp)s
# flake8: noqa

"""

def main():
    """Run administrative tasks."""
    mode = os.environ.get('CI', '').lower() == 'true' and 'ci' or 'dev'
    argv = [a for a in sys.argv if not a.startswith('--')]
    options = [a for a in sys.argv if a.startswith('--')]
    settings = f"pfx.settings.dev"
    cmd = len(argv) > 1 and argv[1]
    if cmd == 'test':
        app = len(argv) > 2 and argv[2] or 'tests'
        if len(argv) <= 2:
            argv.append('tests')
        settings = f"{app.split('.')[0]}.settings.{mode}"
    elif cmd == 'makemigrations':
        app = len(argv) > 2 and argv[2] or 'pfx'
        settings = f"{app}.settings.{app == 'pfx' and 'dev' or 'common'}"
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", settings)
    try:
        from django.core.management import execute_from_command_line
    except ImportError as exc:
        raise ImportError(
            "Couldn't import Django. Are you sure it's installed and "
            "available on your PYTHONPATH environment variable? Did you "
            "forget to activate a virtual environment?"
        ) from exc
    execute_from_command_line([*argv, *options])


if __name__ == '__main__':
    main()
