# Asanai Python Module

[![Release Workflow](https://github.com/NormanTUD/asanAI_python/actions/workflows/release.yml/badge.svg?event=push)](https://github.com/NormanTUD/asanAI_python/actions/workflows/release.yml)

**Asanai** is a Python module that allows you to execute scripts generated from machine learning models created in the [Asanai browser interface](https://asanai.scads.ai/). It handles all necessary conversions from TensorFlow.js to Python and provides seamless integration for running, visualizing, and interacting with models locally.

> ⚠️ **Note:** Users typically do not need to install this module manually. It is automatically handled by the scripts generated by Asanai.

---

## Features

- Execute scripts generated from Asanai directly in Python.
- Automatic conversion of TensorFlow.js models to Python TensorFlow (Keras) format.
- Support for **TensorFlow Sequential models**.
- Visualization support for:
  - Webcam input
  - Static image input
  - Simple and complex image outputs
  - Classification outputs with labeled probabilities
- Beginner-friendly while still supporting advanced usage.

---

## Getting Started

1. **Download your model**
   In the Asanai browser interface, click **"Download model data"** (or *"Modelldaten downloaden"*). Place the downloaded file in the same folder as your generated Python script.

2. **Run the script**

```bash
python3 your_script.py          # Predict using webcam or default behavior
python3 your_script.py 1.jpg 2.jpg 3.jpg  # Predict on specific images

