
from restfulpy.messaging import Messenger


class MockupMessenger(Messenger):
    _last_message = None

    @property
    def last_message(self):
        return self.__class__._last_message

    @last_message.setter
    def last_message(self, value):
        self.__class__._last_message = value

    def send(self, to, subject, body, cc=None, bcc=None, template_string=None, template_filename=None, from_=None):
        self.last_message = {
            'to': to,
            'body': body,
            'subject': subject
        }
