# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-28 06:17
from __future__ import unicode_literals

from django.db import migrations

from django.contrib.auth import get_user_model

from resolwe.permissions.utils import assign_contributor_permissions


def set_processes_owner(apps, schema_editor):
    user_model = get_user_model()

    Process = apps.get_model("flow", "Process")
    for process in Process.objects.all():
        # In migrations contributor is not a real user instance, so we
        # have to get it.
        user = user_model.objects.get(pk=process.contributor.pk)
        assign_contributor_permissions(process, user)


def set_descriptor_owner(apps, schema_editor):
    user_model = get_user_model()

    DescriptorSchema = apps.get_model("flow", "DescriptorSchema")
    for descriptor in DescriptorSchema.objects.all():
        # In migrations contributor is not a real user instance, so we
        # have to get it.
        user = user_model.objects.get(pk=descriptor.contributor.pk)
        assign_contributor_permissions(descriptor, user)


class Migration(migrations.Migration):

    dependencies = [
        ("flow", "0001_squashed_0030_change_slug_field"),
    ]

    operations = [
        migrations.RunPython(set_processes_owner),
        migrations.RunPython(set_descriptor_owner),
    ]
