# Generated by Django 3.1.7 on 2021-10-12 10:39
import os

from django.conf import settings
import django.contrib.postgres.indexes
from django.db import connection, migrations, models
import django.db.models.deletion


def load_triggers(apps, schema_editor):
    file_names = [
        "utils.sql",
        "triggers_collection.sql",
        "triggers_entity.sql",
        "triggers_data.sql",
    ]
    with connection.cursor() as c:
        for file_name in file_names:
            file_path = os.path.join(os.path.dirname(__file__), file_name)
            with open(file_path) as fh:
                sql_statement = fh.read()
            c.execute(sql_statement)


class Migration(migrations.Migration):

    replaces = [
        ("flow", "0044_datalocation_to_filestorage"),
        ("flow", "0045_unreferenced_storages"),
        ("flow", "0046_purge_data_dependencies"),
        ("flow", "0047_duplicate_dependency"),
        ("flow", "0048_worker"),
        ("flow", "0049_json_field"),
    ]

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("storage", "0001_squashed_0009_referencedpath_chunk_size"),
        ("flow", "0001_squashed_0043_full_text_search"),
        ("permissions", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="data",
            name="location",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="data",
                to="storage.filestorage",
            ),
        ),
        migrations.AddField(
            model_name="data",
            name="parents",
            field=models.ManyToManyField(
                related_name="children", through="flow.DataDependency", to="flow.Data"
            ),
        ),
        migrations.AddField(
            model_name="data",
            name="process",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to="flow.process"
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="contributor",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddField(
            model_name="collection",
            name="descriptor_schema",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                to="flow.descriptorschema",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="storage",
            unique_together={("slug", "version")},
        ),
        migrations.AlterUniqueTogether(
            name="relationpartition",
            unique_together={("entity", "relation")},
        ),
        migrations.AlterUniqueTogether(
            name="relation",
            unique_together={("collection", "category")},
        ),
        migrations.AddIndex(
            model_name="process",
            index=models.Index(fields=["name"], name="idx_process_name"),
        ),
        migrations.AddIndex(
            model_name="process",
            index=models.Index(fields=["slug"], name="idx_process_slug"),
        ),
        migrations.AddIndex(
            model_name="process",
            index=models.Index(fields=["type"], name="idx_process_type"),
        ),
        migrations.AddIndex(
            model_name="process",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["type"],
                name="idx_process_type_trgm",
                opclasses=["gin_trgm_ops"],
            ),
        ),
        migrations.AlterUniqueTogether(
            name="process",
            unique_together={("slug", "version")},
        ),
        migrations.AddIndex(
            model_name="entity",
            index=models.Index(fields=["name"], name="idx_entity_name"),
        ),
        migrations.AddIndex(
            model_name="entity",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["name"], name="idx_entity_name_trgm", opclasses=["gin_trgm_ops"]
            ),
        ),
        migrations.AddIndex(
            model_name="entity",
            index=models.Index(fields=["slug"], name="idx_entity_slug"),
        ),
        migrations.AddIndex(
            model_name="entity",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["tags"], name="idx_entity_tags"
            ),
        ),
        migrations.AddIndex(
            model_name="entity",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["search"], name="idx_entity_search"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="entity",
            unique_together={("slug", "version")},
        ),
        migrations.AlterUniqueTogether(
            name="descriptorschema",
            unique_together={("slug", "version")},
        ),
        migrations.AddIndex(
            model_name="data",
            index=models.Index(fields=["name"], name="idx_data_name"),
        ),
        migrations.AddIndex(
            model_name="data",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["name"], name="idx_data_name_trgm", opclasses=["gin_trgm_ops"]
            ),
        ),
        migrations.AddIndex(
            model_name="data",
            index=models.Index(fields=["slug"], name="idx_data_slug"),
        ),
        migrations.AddIndex(
            model_name="data",
            index=models.Index(fields=["status"], name="idx_data_status"),
        ),
        migrations.AddIndex(
            model_name="data",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["tags"], name="idx_data_tags"
            ),
        ),
        migrations.AddIndex(
            model_name="data",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["search"], name="idx_data_search"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="data",
            unique_together={("slug", "version")},
        ),
        migrations.AddIndex(
            model_name="collection",
            index=models.Index(fields=["name"], name="idx_collection_name"),
        ),
        migrations.AddIndex(
            model_name="collection",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["name"],
                name="idx_collection_name_trgm",
                opclasses=["gin_trgm_ops"],
            ),
        ),
        migrations.AddIndex(
            model_name="collection",
            index=models.Index(fields=["slug"], name="idx_collection_slug"),
        ),
        migrations.AddIndex(
            model_name="collection",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["tags"], name="idx_collection_tags"
            ),
        ),
        migrations.AddIndex(
            model_name="collection",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["search"], name="idx_collection_search"
            ),
        ),
        migrations.AlterUniqueTogether(
            name="collection",
            unique_together={("slug", "version")},
        ),
        migrations.RunPython(load_triggers),
    ]
