# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-12-06 05:15
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import fernet_fields.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("flow", "0009_make_size_mandatory"),
    ]

    operations = [
        migrations.CreateModel(
            name="Secret",
            fields=[
                ("created", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("modified", models.DateTimeField(auto_now=True, db_index=True)),
                (
                    "handle",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("value", fernet_fields.fields.EncryptedTextField()),
                (
                    "metadata",
                    django.contrib.postgres.fields.jsonb.JSONField(default=dict),
                ),
                ("expires", models.DateTimeField(db_index=True, null=True)),
                (
                    "contributor",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
