# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.agent_configuration import AgentConfiguration
from ..types.agent_detailed_response import AgentDetailedResponse
from ..types.agent_list_response import AgentListResponse
from ..types.agent_response import AgentResponse
from ..types.success_response import SuccessResponse
from ..types.tool_list_response import ToolListResponse
from .raw_client import AsyncRawAgentsClient, RawAgentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AgentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAgentsClient
        """
        return self._raw_client

    def list_agents(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentListResponse:
        """
        Retrieve all agents for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        search : typing.Optional[str]
            Search agents by name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentListResponse
            Agents retrieved successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.agents.list_agents()
        """
        _response = self._raw_client.list_agents(page=page, limit=limit, search=search, request_options=request_options)
        return _response.data

    def create_agent(
        self,
        *,
        agent_name: str,
        agent_json: AgentConfiguration,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentResponse:
        """
        Create a new AI voice agent with specified configuration

        Parameters
        ----------
        agent_name : str
            Human-readable name for the agent

        agent_json : AgentConfiguration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentResponse
            Agent created successfully

        Examples
        --------
        from sonyk_sdk import (
            AgentConfiguration,
            AgentConfigurationLlm_Openai,
            AgentConfigurationStt_Deepgram,
            AgentConfigurationTts_Elevenlabs,
            SonykClient,
        )

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.agents.create_agent(
            agent_name="Restaurant Receptionist",
            agent_json=AgentConfiguration(
                llm=AgentConfigurationLlm_Openai(
                    model="gpt-5",
                    system_prompt="# Role\nYou are Georgia, a friendly and professional receptionist at the  restaurant.\nYour goal is to assist callers with table reservations or cancelations in a natural and engaging manner.\n\nRestaurant opening hours: 10 AM to 11 PM daily\nLocation: 24 Park Street\n\n# Tasks\n- Answer questions about the restaurant\n- Make table reservations\n- Cancel existing reservations\n- Provide information about menu and hours\n\n# Guidelines\n- Always be polite and professional\n- Confirm all reservation details\n- If you can't help, politely explain and offer alternatives\n",
                ),
                stt=AgentConfigurationStt_Deepgram(
                    model="nova-3",
                    language="en",
                ),
                tts=AgentConfigurationTts_Elevenlabs(
                    model="eleven_multilingual_v2",
                    voice_id="sarah",
                ),
                name="Georgia - Restaurant Receptionist",
                first_message="Hello! Welcome to  restaurant. I'm Georgia, how can I help you today?",
            ),
        )
        """
        _response = self._raw_client.create_agent(
            agent_name=agent_name, agent_json=agent_json, request_options=request_options
        )
        return _response.data

    def get_agent(
        self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AgentDetailedResponse:
        """
        Retrieve a specific agent by ID with full configuration

        Parameters
        ----------
        agent_id : str
            Agent identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentDetailedResponse
            Agent retrieved successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.agents.get_agent(
            agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.get_agent(agent_id, request_options=request_options)
        return _response.data

    def update_agent(
        self,
        agent_id: str,
        *,
        agent_name: typing.Optional[str] = OMIT,
        agent_json: typing.Optional[AgentConfiguration] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentResponse:
        """
        Update agent configuration. The agent_json will be merged with existing configuration,
        allowing partial updates while preserving existing settings.

        Parameters
        ----------
        agent_id : str

        agent_name : typing.Optional[str]

        agent_json : typing.Optional[AgentConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentResponse
            Agent updated successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.agents.update_agent(
            agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.update_agent(
            agent_id, agent_name=agent_name, agent_json=agent_json, request_options=request_options
        )
        return _response.data

    def delete_agent(
        self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Delete an agent (permanent deletion)

        Parameters
        ----------
        agent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Agent deleted successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.agents.delete_agent(
            agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.delete_agent(agent_id, request_options=request_options)
        return _response.data

    def get_agent_tools(
        self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ToolListResponse:
        """
        Retrieve all tools assigned to a specific agent

        Parameters
        ----------
        agent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolListResponse
            Agent tools retrieved successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.agents.get_agent_tools(
            agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.get_agent_tools(agent_id, request_options=request_options)
        return _response.data

    def assign_tool_to_agent(
        self, agent_id: str, *, tool_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Assign an existing tool to an agent

        Parameters
        ----------
        agent_id : str

        tool_id : str
            Tool identifier to assign

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Tool assigned to agent successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.agents.assign_tool_to_agent(
            agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            tool_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.assign_tool_to_agent(agent_id, tool_id=tool_id, request_options=request_options)
        return _response.data

    def unassign_tool_from_agent(
        self, agent_id: str, *, tool_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Remove a tool assignment from an agent

        Parameters
        ----------
        agent_id : str

        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Tool unassigned from agent successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.agents.unassign_tool_from_agent(
            agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            tool_id="toolId",
        )
        """
        _response = self._raw_client.unassign_tool_from_agent(
            agent_id, tool_id=tool_id, request_options=request_options
        )
        return _response.data


class AsyncAgentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAgentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAgentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAgentsClient
        """
        return self._raw_client

    async def list_agents(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentListResponse:
        """
        Retrieve all agents for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        search : typing.Optional[str]
            Search agents by name

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentListResponse
            Agents retrieved successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.list_agents()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_agents(
            page=page, limit=limit, search=search, request_options=request_options
        )
        return _response.data

    async def create_agent(
        self,
        *,
        agent_name: str,
        agent_json: AgentConfiguration,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentResponse:
        """
        Create a new AI voice agent with specified configuration

        Parameters
        ----------
        agent_name : str
            Human-readable name for the agent

        agent_json : AgentConfiguration

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentResponse
            Agent created successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import (
            AgentConfiguration,
            AgentConfigurationLlm_Openai,
            AgentConfigurationStt_Deepgram,
            AgentConfigurationTts_Elevenlabs,
            AsyncSonykClient,
        )

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.create_agent(
                agent_name="Restaurant Receptionist",
                agent_json=AgentConfiguration(
                    llm=AgentConfigurationLlm_Openai(
                        model="gpt-5",
                        system_prompt="# Role\nYou are Georgia, a friendly and professional receptionist at the  restaurant.\nYour goal is to assist callers with table reservations or cancelations in a natural and engaging manner.\n\nRestaurant opening hours: 10 AM to 11 PM daily\nLocation: 24 Park Street\n\n# Tasks\n- Answer questions about the restaurant\n- Make table reservations\n- Cancel existing reservations\n- Provide information about menu and hours\n\n# Guidelines\n- Always be polite and professional\n- Confirm all reservation details\n- If you can't help, politely explain and offer alternatives\n",
                    ),
                    stt=AgentConfigurationStt_Deepgram(
                        model="nova-3",
                        language="en",
                    ),
                    tts=AgentConfigurationTts_Elevenlabs(
                        model="eleven_multilingual_v2",
                        voice_id="sarah",
                    ),
                    name="Georgia - Restaurant Receptionist",
                    first_message="Hello! Welcome to  restaurant. I'm Georgia, how can I help you today?",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_agent(
            agent_name=agent_name, agent_json=agent_json, request_options=request_options
        )
        return _response.data

    async def get_agent(
        self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AgentDetailedResponse:
        """
        Retrieve a specific agent by ID with full configuration

        Parameters
        ----------
        agent_id : str
            Agent identifier

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentDetailedResponse
            Agent retrieved successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.get_agent(
                agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_agent(agent_id, request_options=request_options)
        return _response.data

    async def update_agent(
        self,
        agent_id: str,
        *,
        agent_name: typing.Optional[str] = OMIT,
        agent_json: typing.Optional[AgentConfiguration] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentResponse:
        """
        Update agent configuration. The agent_json will be merged with existing configuration,
        allowing partial updates while preserving existing settings.

        Parameters
        ----------
        agent_id : str

        agent_name : typing.Optional[str]

        agent_json : typing.Optional[AgentConfiguration]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentResponse
            Agent updated successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.update_agent(
                agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_agent(
            agent_id, agent_name=agent_name, agent_json=agent_json, request_options=request_options
        )
        return _response.data

    async def delete_agent(
        self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Delete an agent (permanent deletion)

        Parameters
        ----------
        agent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Agent deleted successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.delete_agent(
                agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_agent(agent_id, request_options=request_options)
        return _response.data

    async def get_agent_tools(
        self, agent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ToolListResponse:
        """
        Retrieve all tools assigned to a specific agent

        Parameters
        ----------
        agent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolListResponse
            Agent tools retrieved successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.get_agent_tools(
                agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_agent_tools(agent_id, request_options=request_options)
        return _response.data

    async def assign_tool_to_agent(
        self, agent_id: str, *, tool_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Assign an existing tool to an agent

        Parameters
        ----------
        agent_id : str

        tool_id : str
            Tool identifier to assign

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Tool assigned to agent successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.assign_tool_to_agent(
                agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
                tool_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.assign_tool_to_agent(
            agent_id, tool_id=tool_id, request_options=request_options
        )
        return _response.data

    async def unassign_tool_from_agent(
        self, agent_id: str, *, tool_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Remove a tool assignment from an agent

        Parameters
        ----------
        agent_id : str

        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Tool unassigned from agent successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.agents.unassign_tool_from_agent(
                agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
                tool_id="toolId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.unassign_tool_from_agent(
            agent_id, tool_id=tool_id, request_options=request_options
        )
        return _response.data
