# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .create_agent_text_asset_response_data_processing_info import CreateAgentTextAssetResponseDataProcessingInfo


class CreateAgentTextAssetResponseData(UniversalBaseModel):
    asset_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="assetId")] = pydantic.Field(
        default=None
    )
    """
    Unique identifier for the created asset
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Title of the created asset
    """

    type: typing.Optional[typing.Literal["TEXT"]] = pydantic.Field(default=None)
    """
    Asset type (always TEXT for text assets)
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cloud storage URL for the content
    """

    text_length: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="textLength")] = pydantic.Field(
        default=None
    )
    """
    Length of the processed text in characters
    """

    chunk_count: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="chunkCount")] = pydantic.Field(
        default=None
    )
    """
    Number of searchable chunks created
    """

    processing_info: typing_extensions.Annotated[
        typing.Optional[CreateAgentTextAssetResponseDataProcessingInfo], FieldMetadata(alias="processingInfo")
    ] = pydantic.Field(default=None)
    """
    Processing details and configuration
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
