# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .get_agent_asset_content_response_data_type import GetAgentAssetContentResponseDataType


class GetAgentAssetContentResponseData(UniversalBaseModel):
    asset_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="assetId")] = pydantic.Field(
        default=None
    )
    """
    Asset identifier
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Asset title
    """

    type: typing.Optional[GetAgentAssetContentResponseDataType] = pydantic.Field(default=None)
    """
    Type of asset
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    The complete text content of the asset.
    
    For FILE assets: Clean, processed text extracted from uploaded files
    For TEXT assets: Original text content as provided
    For TRAINING assets: Combined question and answer content
    """

    content_length: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="contentLength")] = (
        pydantic.Field(default=None)
    )
    """
    Length of the content in characters
    """

    date_created: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="dateCreated")] = (
        pydantic.Field(default=None)
    )
    """
    When the asset was originally created
    """

    last_modified: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="lastModified")] = (
        pydantic.Field(default=None)
    )
    """
    When the asset was last updated
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
