# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .upload_agent_asset_response_data_processing_info import UploadAgentAssetResponseDataProcessingInfo


class UploadAgentAssetResponseData(UniversalBaseModel):
    asset_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="assetId")] = pydantic.Field(
        default=None
    )
    """
    Unique identifier for the created asset
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Final title of the asset
    """

    type: typing.Optional[typing.Literal["FILE"]] = pydantic.Field(default=None)
    """
    Asset type (always FILE for uploads)
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cloud storage URL for the processed content
    """

    text_length: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="textLength")] = pydantic.Field(
        default=None
    )
    """
    Length of the extracted and processed text in characters
    """

    chunk_count: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="chunkCount")] = pydantic.Field(
        default=None
    )
    """
    Number of searchable text chunks created
    """

    file_size: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="fileSize")] = pydantic.Field(
        default=None
    )
    """
    Original file size in bytes
    """

    processing_info: typing_extensions.Annotated[
        typing.Optional[UploadAgentAssetResponseDataProcessingInfo], FieldMetadata(alias="processingInfo")
    ] = pydantic.Field(default=None)
    """
    Detailed information about the processing pipeline
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
