# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class UploadAgentAssetResponseDataProcessingInfo(UniversalBaseModel):
    """
    Detailed information about the processing pipeline
    """

    original_length: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="originalLength")] = (
        pydantic.Field(default=None)
    )
    """
    Length of raw extracted text before AI enhancement
    """

    sanitized_length: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="sanitizedLength")] = (
        pydantic.Field(default=None)
    )
    """
    Length after AI-powered text cleaning and enhancement
    """

    chunk_size: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="chunkSize")] = pydantic.Field(
        default=None
    )
    """
    Target chunk size used for segmentation
    """

    embedding_model: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="embeddingModel")] = (
        pydantic.Field(default=None)
    )
    """
    AI model used for generating vector embeddings
    """

    sanitization_applied: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="sanitizationApplied")
    ] = pydantic.Field(default=None)
    """
    Whether AI text enhancement was applied
    """

    processing_time: typing_extensions.Annotated[typing.Optional[float], FieldMetadata(alias="processingTime")] = (
        pydantic.Field(default=None)
    )
    """
    Processing time in seconds
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
