# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.core_call_response import CoreCallResponse
from .raw_client import AsyncRawCallsClient, RawCallsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CallsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCallsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCallsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCallsClient
        """
        return self._raw_client

    def initiate_call(
        self,
        *,
        agent_id: str,
        to_number: str,
        variables: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CoreCallResponse:
        """
        Proxy endpoint to initiate calls through the Sonyk Core API system.
        Validates permissions and credits, then forwards request to core.sonyk.io.

        Parameters
        ----------
        agent_id : str
            UUID of the agent to use for the call

        to_number : str
            Phone number to call (E.164 format)

        variables : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Optional JSON object containing custom variables to pass to the agent during the call

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CoreCallResponse
            Call initiated successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.calls.initiate_call(
            agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            to_number="+xxxxxxxxxx",
        )
        """
        _response = self._raw_client.initiate_call(
            agent_id=agent_id, to_number=to_number, variables=variables, request_options=request_options
        )
        return _response.data


class AsyncCallsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCallsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCallsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCallsClient
        """
        return self._raw_client

    async def initiate_call(
        self,
        *,
        agent_id: str,
        to_number: str,
        variables: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CoreCallResponse:
        """
        Proxy endpoint to initiate calls through the Sonyk Core API system.
        Validates permissions and credits, then forwards request to core.sonyk.io.

        Parameters
        ----------
        agent_id : str
            UUID of the agent to use for the call

        to_number : str
            Phone number to call (E.164 format)

        variables : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Optional JSON object containing custom variables to pass to the agent during the call

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CoreCallResponse
            Call initiated successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.calls.initiate_call(
                agent_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
                to_number="+xxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.initiate_call(
            agent_id=agent_id, to_number=to_number, variables=variables, request_options=request_options
        )
        return _response.data
