# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.phone_list_response import PhoneListResponse
from ..types.phone_response import PhoneResponse
from ..types.success_response import SuccessResponse
from .raw_client import AsyncRawPhonesClient, RawPhonesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PhonesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPhonesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPhonesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPhonesClient
        """
        return self._raw_client

    def list_phones(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        provider: typing.Optional[str] = None,
        is_active: typing.Optional[bool] = None,
        agent_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PhoneListResponse:
        """
        Retrieve all phone numbers for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        provider : typing.Optional[str]
            Filter by phone provider

        is_active : typing.Optional[bool]
            Filter by active status

        agent_id : typing.Optional[str]
            Filter by assigned agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneListResponse
            Phones retrieved successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.phones.list_phones(
            provider="twilio",
        )
        """
        _response = self._raw_client.list_phones(
            page=page,
            limit=limit,
            provider=provider,
            is_active=is_active,
            agent_id=agent_id,
            request_options=request_options,
        )
        return _response.data

    def create_phone(
        self,
        *,
        phone_number: str,
        provider: str,
        twilio_sid: str,
        twilio_token: str,
        nickname: typing.Optional[str] = OMIT,
        agent_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PhoneResponse:
        """
        Add a new phone number to the organization

        Parameters
        ----------
        phone_number : str
            Phone number in E.164 format

        provider : str
            Phone service provider

        twilio_sid : str
            Twilio SID

        twilio_token : str
            Twilio Token

        nickname : typing.Optional[str]
            Optional friendly name for the phone

        agent_id : typing.Optional[str]
            Optional agent to assign the phone to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone created successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.phones.create_phone(
            phone_number="+xxxxxxxxxx",
            provider="twilio",
            twilio_sid="ACxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            twilio_token="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
        )
        """
        _response = self._raw_client.create_phone(
            phone_number=phone_number,
            provider=provider,
            twilio_sid=twilio_sid,
            twilio_token=twilio_token,
            nickname=nickname,
            agent_id=agent_id,
            request_options=request_options,
        )
        return _response.data

    def get_phone(self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> PhoneResponse:
        """
        Retrieve a specific phone by ID

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone retrieved successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.phones.get_phone(
            phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.get_phone(phone_id, request_options=request_options)
        return _response.data

    def update_phone(
        self,
        phone_id: str,
        *,
        nickname: typing.Optional[str] = OMIT,
        agent_id: typing.Optional[str] = OMIT,
        is_active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PhoneResponse:
        """
        Update phone details or agent assignment

        Parameters
        ----------
        phone_id : str

        nickname : typing.Optional[str]

        agent_id : typing.Optional[str]
            Agent ID to assign (null to unassign)

        is_active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone updated successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.phones.update_phone(
            phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.update_phone(
            phone_id, nickname=nickname, agent_id=agent_id, is_active=is_active, request_options=request_options
        )
        return _response.data

    def delete_phone(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Deactivate a phone number

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Phone deleted successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.phones.delete_phone(
            phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.delete_phone(phone_id, request_options=request_options)
        return _response.data

    def map_phone_to_agent(
        self, phone_id: str, *, agent_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneResponse:
        """
        Assign a phone number to a specific agent

        Parameters
        ----------
        phone_id : str

        agent_id : str
            Agent ID to assign the phone to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone mapped to agent successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.phones.map_phone_to_agent(
            phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            agent_id="agentId",
        )
        """
        _response = self._raw_client.map_phone_to_agent(phone_id, agent_id=agent_id, request_options=request_options)
        return _response.data

    def unmap_phone_from_agent(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneResponse:
        """
        Remove agent assignment from a phone number

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone unmapped from agent successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.phones.unmap_phone_from_agent(
            phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.unmap_phone_from_agent(phone_id, request_options=request_options)
        return _response.data


class AsyncPhonesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPhonesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPhonesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPhonesClient
        """
        return self._raw_client

    async def list_phones(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        provider: typing.Optional[str] = None,
        is_active: typing.Optional[bool] = None,
        agent_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PhoneListResponse:
        """
        Retrieve all phone numbers for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        provider : typing.Optional[str]
            Filter by phone provider

        is_active : typing.Optional[bool]
            Filter by active status

        agent_id : typing.Optional[str]
            Filter by assigned agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneListResponse
            Phones retrieved successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phones.list_phones(
                provider="twilio",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_phones(
            page=page,
            limit=limit,
            provider=provider,
            is_active=is_active,
            agent_id=agent_id,
            request_options=request_options,
        )
        return _response.data

    async def create_phone(
        self,
        *,
        phone_number: str,
        provider: str,
        twilio_sid: str,
        twilio_token: str,
        nickname: typing.Optional[str] = OMIT,
        agent_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PhoneResponse:
        """
        Add a new phone number to the organization

        Parameters
        ----------
        phone_number : str
            Phone number in E.164 format

        provider : str
            Phone service provider

        twilio_sid : str
            Twilio SID

        twilio_token : str
            Twilio Token

        nickname : typing.Optional[str]
            Optional friendly name for the phone

        agent_id : typing.Optional[str]
            Optional agent to assign the phone to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone created successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phones.create_phone(
                phone_number="+xxxxxxxxxx",
                provider="twilio",
                twilio_sid="ACxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                twilio_token="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_phone(
            phone_number=phone_number,
            provider=provider,
            twilio_sid=twilio_sid,
            twilio_token=twilio_token,
            nickname=nickname,
            agent_id=agent_id,
            request_options=request_options,
        )
        return _response.data

    async def get_phone(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneResponse:
        """
        Retrieve a specific phone by ID

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone retrieved successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phones.get_phone(
                phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_phone(phone_id, request_options=request_options)
        return _response.data

    async def update_phone(
        self,
        phone_id: str,
        *,
        nickname: typing.Optional[str] = OMIT,
        agent_id: typing.Optional[str] = OMIT,
        is_active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PhoneResponse:
        """
        Update phone details or agent assignment

        Parameters
        ----------
        phone_id : str

        nickname : typing.Optional[str]

        agent_id : typing.Optional[str]
            Agent ID to assign (null to unassign)

        is_active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone updated successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phones.update_phone(
                phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_phone(
            phone_id, nickname=nickname, agent_id=agent_id, is_active=is_active, request_options=request_options
        )
        return _response.data

    async def delete_phone(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Deactivate a phone number

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Phone deleted successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phones.delete_phone(
                phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_phone(phone_id, request_options=request_options)
        return _response.data

    async def map_phone_to_agent(
        self, phone_id: str, *, agent_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneResponse:
        """
        Assign a phone number to a specific agent

        Parameters
        ----------
        phone_id : str

        agent_id : str
            Agent ID to assign the phone to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone mapped to agent successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phones.map_phone_to_agent(
                phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
                agent_id="agentId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.map_phone_to_agent(
            phone_id, agent_id=agent_id, request_options=request_options
        )
        return _response.data

    async def unmap_phone_from_agent(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PhoneResponse:
        """
        Remove agent assignment from a phone number

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneResponse
            Phone unmapped from agent successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.phones.unmap_phone_from_agent(
                phone_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.unmap_phone_from_agent(phone_id, request_options=request_options)
        return _response.data
