# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..types.phone_list_response import PhoneListResponse
from ..types.phone_response import PhoneResponse
from ..types.success_response import SuccessResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPhonesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_phones(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        provider: typing.Optional[str] = None,
        is_active: typing.Optional[bool] = None,
        agent_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PhoneListResponse]:
        """
        Retrieve all phone numbers for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        provider : typing.Optional[str]
            Filter by phone provider

        is_active : typing.Optional[bool]
            Filter by active status

        agent_id : typing.Optional[str]
            Filter by assigned agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PhoneListResponse]
            Phones retrieved successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/developer/phones",
            method="GET",
            params={
                "page": page,
                "limit": limit,
                "provider": provider,
                "is_active": is_active,
                "agentId": agent_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneListResponse,
                    parse_obj_as(
                        type_=PhoneListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_phone(
        self,
        *,
        phone_number: str,
        provider: str,
        twilio_sid: str,
        twilio_token: str,
        nickname: typing.Optional[str] = OMIT,
        agent_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PhoneResponse]:
        """
        Add a new phone number to the organization

        Parameters
        ----------
        phone_number : str
            Phone number in E.164 format

        provider : str
            Phone service provider

        twilio_sid : str
            Twilio SID

        twilio_token : str
            Twilio Token

        nickname : typing.Optional[str]
            Optional friendly name for the phone

        agent_id : typing.Optional[str]
            Optional agent to assign the phone to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PhoneResponse]
            Phone created successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/developer/phones",
            method="POST",
            json={
                "phoneNumber": phone_number,
                "provider": provider,
                "twilioSid": twilio_sid,
                "twilioToken": twilio_token,
                "nickname": nickname,
                "agentId": agent_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_phone(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PhoneResponse]:
        """
        Retrieve a specific phone by ID

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PhoneResponse]
            Phone retrieved successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_phone(
        self,
        phone_id: str,
        *,
        nickname: typing.Optional[str] = OMIT,
        agent_id: typing.Optional[str] = OMIT,
        is_active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PhoneResponse]:
        """
        Update phone details or agent assignment

        Parameters
        ----------
        phone_id : str

        nickname : typing.Optional[str]

        agent_id : typing.Optional[str]
            Agent ID to assign (null to unassign)

        is_active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PhoneResponse]
            Phone updated successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}",
            method="PUT",
            json={
                "nickname": nickname,
                "agentId": agent_id,
                "isActive": is_active,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_phone(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SuccessResponse]:
        """
        Deactivate a phone number

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SuccessResponse]
            Phone deleted successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SuccessResponse,
                    parse_obj_as(
                        type_=SuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def map_phone_to_agent(
        self, phone_id: str, *, agent_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PhoneResponse]:
        """
        Assign a phone number to a specific agent

        Parameters
        ----------
        phone_id : str

        agent_id : str
            Agent ID to assign the phone to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PhoneResponse]
            Phone mapped to agent successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}/map-agent",
            method="POST",
            json={
                "agentId": agent_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def unmap_phone_from_agent(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PhoneResponse]:
        """
        Remove agent assignment from a phone number

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PhoneResponse]
            Phone unmapped from agent successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}/unmap-agent",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPhonesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_phones(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        provider: typing.Optional[str] = None,
        is_active: typing.Optional[bool] = None,
        agent_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PhoneListResponse]:
        """
        Retrieve all phone numbers for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        provider : typing.Optional[str]
            Filter by phone provider

        is_active : typing.Optional[bool]
            Filter by active status

        agent_id : typing.Optional[str]
            Filter by assigned agent

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PhoneListResponse]
            Phones retrieved successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/developer/phones",
            method="GET",
            params={
                "page": page,
                "limit": limit,
                "provider": provider,
                "is_active": is_active,
                "agentId": agent_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneListResponse,
                    parse_obj_as(
                        type_=PhoneListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_phone(
        self,
        *,
        phone_number: str,
        provider: str,
        twilio_sid: str,
        twilio_token: str,
        nickname: typing.Optional[str] = OMIT,
        agent_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PhoneResponse]:
        """
        Add a new phone number to the organization

        Parameters
        ----------
        phone_number : str
            Phone number in E.164 format

        provider : str
            Phone service provider

        twilio_sid : str
            Twilio SID

        twilio_token : str
            Twilio Token

        nickname : typing.Optional[str]
            Optional friendly name for the phone

        agent_id : typing.Optional[str]
            Optional agent to assign the phone to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PhoneResponse]
            Phone created successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/developer/phones",
            method="POST",
            json={
                "phoneNumber": phone_number,
                "provider": provider,
                "twilioSid": twilio_sid,
                "twilioToken": twilio_token,
                "nickname": nickname,
                "agentId": agent_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_phone(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PhoneResponse]:
        """
        Retrieve a specific phone by ID

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PhoneResponse]
            Phone retrieved successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_phone(
        self,
        phone_id: str,
        *,
        nickname: typing.Optional[str] = OMIT,
        agent_id: typing.Optional[str] = OMIT,
        is_active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PhoneResponse]:
        """
        Update phone details or agent assignment

        Parameters
        ----------
        phone_id : str

        nickname : typing.Optional[str]

        agent_id : typing.Optional[str]
            Agent ID to assign (null to unassign)

        is_active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PhoneResponse]
            Phone updated successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}",
            method="PUT",
            json={
                "nickname": nickname,
                "agentId": agent_id,
                "isActive": is_active,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_phone(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SuccessResponse]:
        """
        Deactivate a phone number

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SuccessResponse]
            Phone deleted successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SuccessResponse,
                    parse_obj_as(
                        type_=SuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def map_phone_to_agent(
        self, phone_id: str, *, agent_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PhoneResponse]:
        """
        Assign a phone number to a specific agent

        Parameters
        ----------
        phone_id : str

        agent_id : str
            Agent ID to assign the phone to

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PhoneResponse]
            Phone mapped to agent successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}/map-agent",
            method="POST",
            json={
                "agentId": agent_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def unmap_phone_from_agent(
        self, phone_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PhoneResponse]:
        """
        Remove agent assignment from a phone number

        Parameters
        ----------
        phone_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PhoneResponse]
            Phone unmapped from agent successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/developer/phones/{jsonable_encoder(phone_id)}/unmap-agent",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PhoneResponse,
                    parse_obj_as(
                        type_=PhoneResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
