# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_tool_parameter_request import CreateToolParameterRequest
from ..types.success_response import SuccessResponse
from ..types.tool_list_response import ToolListResponse
from ..types.tool_response import ToolResponse
from .raw_client import AsyncRawToolsClient, RawToolsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ToolsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawToolsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawToolsClient
        """
        return self._raw_client

    def list_tools(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ToolListResponse:
        """
        Retrieve all available tools for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        search : typing.Optional[str]
            Search tools by name or description

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolListResponse
            Tools retrieved successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.tools.list_tools()
        """
        _response = self._raw_client.list_tools(page=page, limit=limit, search=search, request_options=request_options)
        return _response.data

    def create_tool(
        self,
        *,
        tool_name: str,
        tool_description: str,
        server_url: str,
        parameters: typing.Optional[typing.Sequence[CreateToolParameterRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ToolResponse:
        """
        Create a new tool/function that can be assigned to agents

        Parameters
        ----------
        tool_name : str
            Unique name for the tool. This will be the function name that the agent uses.
            Use snake_case format (e.g., make_reservation, get_weather, send_email).

        tool_description : str
            Detailed description of what the tool does. The agent uses this to understand
            when and how to use the tool. Be specific about the tool's purpose and behavior.

        server_url : str
            The API endpoint URL that will be called when the agent uses this tool.
            This should be a complete, accessible URL that accepts the specified HTTP method.

        parameters : typing.Optional[typing.Sequence[CreateToolParameterRequest]]
            Parameters that the tool accepts. Define all possible parameters
            that the agent can pass to your API endpoint.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolResponse
            Tool created successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.tools.create_tool(
            tool_name="make_reservation",
            tool_description="Creates a new restaurant reservation with the specified date, time, party size, and customer details",
            server_url="https://api.restaurant.com/reservations",
        )
        """
        _response = self._raw_client.create_tool(
            tool_name=tool_name,
            tool_description=tool_description,
            server_url=server_url,
            parameters=parameters,
            request_options=request_options,
        )
        return _response.data

    def get_tool(self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ToolResponse:
        """
        Retrieve a specific tool by ID

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolResponse
            Tool retrieved successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.tools.get_tool(
            tool_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.get_tool(tool_id, request_options=request_options)
        return _response.data

    def update_tool(
        self,
        tool_id: str,
        *,
        tool_name: str,
        tool_description: str,
        server_url: str,
        parameters: typing.Optional[typing.Sequence[CreateToolParameterRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ToolResponse:
        """
        Update tool configuration

        Parameters
        ----------
        tool_id : str

        tool_name : str
            Unique name for the tool. This will be the function name that the agent uses.
            Use snake_case format (e.g., make_reservation, get_weather, send_email).

        tool_description : str
            Detailed description of what the tool does. The agent uses this to understand
            when and how to use the tool. Be specific about the tool's purpose and behavior.

        server_url : str
            The API endpoint URL that will be called when the agent uses this tool.
            This should be a complete, accessible URL that accepts the specified HTTP method.

        parameters : typing.Optional[typing.Sequence[CreateToolParameterRequest]]
            Parameters that the tool accepts. Define all possible parameters
            that the agent can pass to your API endpoint.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolResponse
            Tool updated successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.tools.update_tool(
            tool_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            tool_name="make_reservation",
            tool_description="Creates a new restaurant reservation with the specified date, time, party size, and customer details",
            server_url="https://api.restaurant.com/reservations",
        )
        """
        _response = self._raw_client.update_tool(
            tool_id,
            tool_name=tool_name,
            tool_description=tool_description,
            server_url=server_url,
            parameters=parameters,
            request_options=request_options,
        )
        return _response.data

    def delete_tool(self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Delete a tool

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Tool deleted successfully

        Examples
        --------
        from sonyk_sdk import SonykClient

        client = SonykClient(
            api_key="YOUR_API_KEY",
        )
        client.tools.delete_tool(
            tool_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
        )
        """
        _response = self._raw_client.delete_tool(tool_id, request_options=request_options)
        return _response.data


class AsyncToolsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawToolsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawToolsClient
        """
        return self._raw_client

    async def list_tools(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ToolListResponse:
        """
        Retrieve all available tools for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        search : typing.Optional[str]
            Search tools by name or description

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolListResponse
            Tools retrieved successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.list_tools()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_tools(
            page=page, limit=limit, search=search, request_options=request_options
        )
        return _response.data

    async def create_tool(
        self,
        *,
        tool_name: str,
        tool_description: str,
        server_url: str,
        parameters: typing.Optional[typing.Sequence[CreateToolParameterRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ToolResponse:
        """
        Create a new tool/function that can be assigned to agents

        Parameters
        ----------
        tool_name : str
            Unique name for the tool. This will be the function name that the agent uses.
            Use snake_case format (e.g., make_reservation, get_weather, send_email).

        tool_description : str
            Detailed description of what the tool does. The agent uses this to understand
            when and how to use the tool. Be specific about the tool's purpose and behavior.

        server_url : str
            The API endpoint URL that will be called when the agent uses this tool.
            This should be a complete, accessible URL that accepts the specified HTTP method.

        parameters : typing.Optional[typing.Sequence[CreateToolParameterRequest]]
            Parameters that the tool accepts. Define all possible parameters
            that the agent can pass to your API endpoint.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolResponse
            Tool created successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.create_tool(
                tool_name="make_reservation",
                tool_description="Creates a new restaurant reservation with the specified date, time, party size, and customer details",
                server_url="https://api.restaurant.com/reservations",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_tool(
            tool_name=tool_name,
            tool_description=tool_description,
            server_url=server_url,
            parameters=parameters,
            request_options=request_options,
        )
        return _response.data

    async def get_tool(self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ToolResponse:
        """
        Retrieve a specific tool by ID

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolResponse
            Tool retrieved successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.get_tool(
                tool_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_tool(tool_id, request_options=request_options)
        return _response.data

    async def update_tool(
        self,
        tool_id: str,
        *,
        tool_name: str,
        tool_description: str,
        server_url: str,
        parameters: typing.Optional[typing.Sequence[CreateToolParameterRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ToolResponse:
        """
        Update tool configuration

        Parameters
        ----------
        tool_id : str

        tool_name : str
            Unique name for the tool. This will be the function name that the agent uses.
            Use snake_case format (e.g., make_reservation, get_weather, send_email).

        tool_description : str
            Detailed description of what the tool does. The agent uses this to understand
            when and how to use the tool. Be specific about the tool's purpose and behavior.

        server_url : str
            The API endpoint URL that will be called when the agent uses this tool.
            This should be a complete, accessible URL that accepts the specified HTTP method.

        parameters : typing.Optional[typing.Sequence[CreateToolParameterRequest]]
            Parameters that the tool accepts. Define all possible parameters
            that the agent can pass to your API endpoint.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ToolResponse
            Tool updated successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.update_tool(
                tool_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
                tool_name="make_reservation",
                tool_description="Creates a new restaurant reservation with the specified date, time, party size, and customer details",
                server_url="https://api.restaurant.com/reservations",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_tool(
            tool_id,
            tool_name=tool_name,
            tool_description=tool_description,
            server_url=server_url,
            parameters=parameters,
            request_options=request_options,
        )
        return _response.data

    async def delete_tool(
        self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SuccessResponse:
        """
        Delete a tool

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Tool deleted successfully

        Examples
        --------
        import asyncio

        from sonyk_sdk import AsyncSonykClient

        client = AsyncSonykClient(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.tools.delete_tool(
                tool_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxx",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_tool(tool_id, request_options=request_options)
        return _response.data
