# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..types.create_tool_parameter_request import CreateToolParameterRequest
from ..types.success_response import SuccessResponse
from ..types.tool_list_response import ToolListResponse
from ..types.tool_response import ToolResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawToolsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_tools(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ToolListResponse]:
        """
        Retrieve all available tools for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        search : typing.Optional[str]
            Search tools by name or description

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ToolListResponse]
            Tools retrieved successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/developer/tools",
            method="GET",
            params={
                "page": page,
                "limit": limit,
                "search": search,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolListResponse,
                    parse_obj_as(
                        type_=ToolListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_tool(
        self,
        *,
        tool_name: str,
        tool_description: str,
        server_url: str,
        parameters: typing.Optional[typing.Sequence[CreateToolParameterRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ToolResponse]:
        """
        Create a new tool/function that can be assigned to agents

        Parameters
        ----------
        tool_name : str
            Unique name for the tool. This will be the function name that the agent uses.
            Use snake_case format (e.g., make_reservation, get_weather, send_email).

        tool_description : str
            Detailed description of what the tool does. The agent uses this to understand
            when and how to use the tool. Be specific about the tool's purpose and behavior.

        server_url : str
            The API endpoint URL that will be called when the agent uses this tool.
            This should be a complete, accessible URL that accepts the specified HTTP method.

        parameters : typing.Optional[typing.Sequence[CreateToolParameterRequest]]
            Parameters that the tool accepts. Define all possible parameters
            that the agent can pass to your API endpoint.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ToolResponse]
            Tool created successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/developer/tools",
            method="POST",
            json={
                "tool_name": tool_name,
                "tool_description": tool_description,
                "server_url": server_url,
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=typing.Sequence[CreateToolParameterRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolResponse,
                    parse_obj_as(
                        type_=ToolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_tool(
        self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ToolResponse]:
        """
        Retrieve a specific tool by ID

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ToolResponse]
            Tool retrieved successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/developer/tools/{jsonable_encoder(tool_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolResponse,
                    parse_obj_as(
                        type_=ToolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_tool(
        self,
        tool_id: str,
        *,
        tool_name: str,
        tool_description: str,
        server_url: str,
        parameters: typing.Optional[typing.Sequence[CreateToolParameterRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ToolResponse]:
        """
        Update tool configuration

        Parameters
        ----------
        tool_id : str

        tool_name : str
            Unique name for the tool. This will be the function name that the agent uses.
            Use snake_case format (e.g., make_reservation, get_weather, send_email).

        tool_description : str
            Detailed description of what the tool does. The agent uses this to understand
            when and how to use the tool. Be specific about the tool's purpose and behavior.

        server_url : str
            The API endpoint URL that will be called when the agent uses this tool.
            This should be a complete, accessible URL that accepts the specified HTTP method.

        parameters : typing.Optional[typing.Sequence[CreateToolParameterRequest]]
            Parameters that the tool accepts. Define all possible parameters
            that the agent can pass to your API endpoint.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ToolResponse]
            Tool updated successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/developer/tools/{jsonable_encoder(tool_id)}",
            method="PUT",
            json={
                "tool_name": tool_name,
                "tool_description": tool_description,
                "server_url": server_url,
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=typing.Sequence[CreateToolParameterRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolResponse,
                    parse_obj_as(
                        type_=ToolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_tool(
        self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SuccessResponse]:
        """
        Delete a tool

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SuccessResponse]
            Tool deleted successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/developer/tools/{jsonable_encoder(tool_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SuccessResponse,
                    parse_obj_as(
                        type_=SuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawToolsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_tools(
        self,
        *,
        page: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        search: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ToolListResponse]:
        """
        Retrieve all available tools for the organization

        Parameters
        ----------
        page : typing.Optional[int]
            Page number for pagination

        limit : typing.Optional[int]
            Number of items per page

        search : typing.Optional[str]
            Search tools by name or description

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ToolListResponse]
            Tools retrieved successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/developer/tools",
            method="GET",
            params={
                "page": page,
                "limit": limit,
                "search": search,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolListResponse,
                    parse_obj_as(
                        type_=ToolListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_tool(
        self,
        *,
        tool_name: str,
        tool_description: str,
        server_url: str,
        parameters: typing.Optional[typing.Sequence[CreateToolParameterRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ToolResponse]:
        """
        Create a new tool/function that can be assigned to agents

        Parameters
        ----------
        tool_name : str
            Unique name for the tool. This will be the function name that the agent uses.
            Use snake_case format (e.g., make_reservation, get_weather, send_email).

        tool_description : str
            Detailed description of what the tool does. The agent uses this to understand
            when and how to use the tool. Be specific about the tool's purpose and behavior.

        server_url : str
            The API endpoint URL that will be called when the agent uses this tool.
            This should be a complete, accessible URL that accepts the specified HTTP method.

        parameters : typing.Optional[typing.Sequence[CreateToolParameterRequest]]
            Parameters that the tool accepts. Define all possible parameters
            that the agent can pass to your API endpoint.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ToolResponse]
            Tool created successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/developer/tools",
            method="POST",
            json={
                "tool_name": tool_name,
                "tool_description": tool_description,
                "server_url": server_url,
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=typing.Sequence[CreateToolParameterRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolResponse,
                    parse_obj_as(
                        type_=ToolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_tool(
        self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ToolResponse]:
        """
        Retrieve a specific tool by ID

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ToolResponse]
            Tool retrieved successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/developer/tools/{jsonable_encoder(tool_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolResponse,
                    parse_obj_as(
                        type_=ToolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_tool(
        self,
        tool_id: str,
        *,
        tool_name: str,
        tool_description: str,
        server_url: str,
        parameters: typing.Optional[typing.Sequence[CreateToolParameterRequest]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ToolResponse]:
        """
        Update tool configuration

        Parameters
        ----------
        tool_id : str

        tool_name : str
            Unique name for the tool. This will be the function name that the agent uses.
            Use snake_case format (e.g., make_reservation, get_weather, send_email).

        tool_description : str
            Detailed description of what the tool does. The agent uses this to understand
            when and how to use the tool. Be specific about the tool's purpose and behavior.

        server_url : str
            The API endpoint URL that will be called when the agent uses this tool.
            This should be a complete, accessible URL that accepts the specified HTTP method.

        parameters : typing.Optional[typing.Sequence[CreateToolParameterRequest]]
            Parameters that the tool accepts. Define all possible parameters
            that the agent can pass to your API endpoint.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ToolResponse]
            Tool updated successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/developer/tools/{jsonable_encoder(tool_id)}",
            method="PUT",
            json={
                "tool_name": tool_name,
                "tool_description": tool_description,
                "server_url": server_url,
                "parameters": convert_and_respect_annotation_metadata(
                    object_=parameters, annotation=typing.Sequence[CreateToolParameterRequest], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ToolResponse,
                    parse_obj_as(
                        type_=ToolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_tool(
        self, tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SuccessResponse]:
        """
        Delete a tool

        Parameters
        ----------
        tool_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SuccessResponse]
            Tool deleted successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/developer/tools/{jsonable_encoder(tool_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SuccessResponse,
                    parse_obj_as(
                        type_=SuccessResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
