# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .agent_configuration import AgentConfiguration


class Agent(UniversalBaseModel):
    agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique agent identifier
    """

    agent_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human-readable agent name
    """

    agent_json: typing.Optional[AgentConfiguration] = None
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Agent creation timestamp
    """

    fk_org_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    Organization ID that owns this agent
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
