# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .agent_configuration_llm import AgentConfigurationLlm
from .agent_configuration_structured_data_schema import AgentConfigurationStructuredDataSchema
from .agent_configuration_stt import AgentConfigurationStt
from .agent_configuration_tts import AgentConfigurationTts


class AgentConfiguration(UniversalBaseModel):
    """
    Complete configuration object for an AI voice agent. This JSON structure defines
    all aspects of the agent's behavior, voice characteristics, and integrations.

    ## Key Components:

    ### LLM (Large Language Model)
    Controls the agent's conversational intelligence and reasoning capabilities.

    ### STT (Speech-to-Text)
    Handles voice recognition and transcription of caller speech.

    ### TTS (Text-to-Speech)
    Manages voice synthesis and how the agent sounds to callers.

    ### Behavior Settings
    Defines conversation flow, greetings, and interaction patterns.
    """

    llm: AgentConfigurationLlm = pydantic.Field()
    """
    Large Language Model configuration that powers the agent's conversational abilities.
    This is the "brain" of your agent that processes user input and generates responses.
    """

    stt: AgentConfigurationStt = pydantic.Field()
    """
    Speech-to-Text configuration that converts caller voice to text.
    This determines how accurately the agent understands what callers say.
    """

    tts: AgentConfigurationTts = pydantic.Field()
    """
    Text-to-Speech configuration that controls how the agent's voice sounds.
    This determines the personality and quality of the agent's speech.
    """

    name: str = pydantic.Field()
    """
    Display name for the agent (for your reference)
    """

    first_message: typing_extensions.Annotated[str, FieldMetadata(alias="firstMessage")] = pydantic.Field()
    """
    **Critical Setting**: The first thing your agent says when someone calls.
    This sets the tone for the entire conversation.
    
    **Tips:**
    - Keep it friendly and professional
    - Clearly identify who/what the agent represents
    - Ask how you can help
    - Keep it under 20 words for best experience
    """

    webhook_url: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="webhookUrl")] = pydantic.Field(
        default=None
    )
    """
    Optional webhook URL to receive call events and data.
    Your server will receive POST requests with:
    - Call transcripts
    - Call summaries
    - Call duration and costs
    - Custom data from tool executions
    """

    call_forward_number: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="callForwardNumber")] = (
        pydantic.Field(default=None)
    )
    """
    Optional phone number to forward calls to if the agent cannot handle them.
    Useful for escalation or human handoff.
    """

    structured_data_schema: typing_extensions.Annotated[
        typing.Optional[AgentConfigurationStructuredDataSchema], FieldMetadata(alias="structuredDataSchema")
    ] = pydantic.Field(default=None)
    """
    Schema definition for structured data extraction from calls.
    This defines what data should be captured and returned after each call.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
