# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .anthropic_llm_model import AnthropicLlmModel
from .groq_llm_model import GroqLlmModel
from .open_aillm_model import OpenAillmModel


class AgentConfigurationLlm_Openai(UniversalBaseModel):
    """
    Large Language Model configuration that powers the agent's conversational abilities.
    This is the "brain" of your agent that processes user input and generates responses.
    """

    provider: typing.Literal["openai"] = "openai"
    model: OpenAillmModel
    system_prompt: typing_extensions.Annotated[str, FieldMetadata(alias="systemPrompt")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AgentConfigurationLlm_Anthropic(UniversalBaseModel):
    """
    Large Language Model configuration that powers the agent's conversational abilities.
    This is the "brain" of your agent that processes user input and generates responses.
    """

    provider: typing.Literal["anthropic"] = "anthropic"
    model: AnthropicLlmModel
    system_prompt: typing_extensions.Annotated[str, FieldMetadata(alias="systemPrompt")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AgentConfigurationLlm_Groq(UniversalBaseModel):
    """
    Large Language Model configuration that powers the agent's conversational abilities.
    This is the "brain" of your agent that processes user input and generates responses.
    """

    provider: typing.Literal["groq"] = "groq"
    model: GroqLlmModel
    system_prompt: typing_extensions.Annotated[str, FieldMetadata(alias="systemPrompt")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AgentConfigurationLlm = typing.Union[
    AgentConfigurationLlm_Openai, AgentConfigurationLlm_Anthropic, AgentConfigurationLlm_Groq
]
