# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .agent_configuration_structured_data_schema_call_type import AgentConfigurationStructuredDataSchemaCallType


class AgentConfigurationStructuredDataSchema(UniversalBaseModel):
    """
    Schema definition for structured data extraction from calls.
    This defines what data should be captured and returned after each call.
    """

    tags: typing.List[str] = pydantic.Field()
    """
    Array of tags to categorize the call
    """

    call_type: AgentConfigurationStructuredDataSchemaCallType = pydantic.Field()
    """
    Type/category of the call
    """

    call_summary: str = pydantic.Field()
    """
    Brief summary of the call content
    """

    send_menu_dish_sms: typing_extensions.Annotated[typing.Optional[bool], FieldMetadata(alias="sendMenuDishSMS")] = (
        pydantic.Field(default=None)
    )
    """
    Whether to send menu/dish information via SMS
    """

    reason_of_call_transfer: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="reasonOfCallTransfer")
    ] = pydantic.Field(default=None)
    """
    Reason if the call was transferred to a human
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
