# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .deepgram_stt_model import DeepgramSttModel


class AgentConfigurationStt_Deepgram(UniversalBaseModel):
    """
    Speech-to-Text configuration that converts caller voice to text.
    This determines how accurately the agent understands what callers say.
    """

    provider: typing.Literal["deepgram"] = "deepgram"
    model: DeepgramSttModel
    language: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AgentConfigurationStt = AgentConfigurationStt_Deepgram
