# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .cartesia_tts_model import CartesiaTtsModel
from .eleven_labs_tts_model import ElevenLabsTtsModel
from .groq_tts_model import GroqTtsModel


class AgentConfigurationTts_Elevenlabs(UniversalBaseModel):
    """
    Text-to-Speech configuration that controls how the agent's voice sounds.
    This determines the personality and quality of the agent's speech.
    """

    provider: typing.Literal["elevenlabs"] = "elevenlabs"
    model: ElevenLabsTtsModel
    voice_id: typing_extensions.Annotated[str, FieldMetadata(alias="voiceId")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AgentConfigurationTts_Cartesia(UniversalBaseModel):
    """
    Text-to-Speech configuration that controls how the agent's voice sounds.
    This determines the personality and quality of the agent's speech.
    """

    provider: typing.Literal["cartesia"] = "cartesia"
    model: CartesiaTtsModel
    voice_id: typing_extensions.Annotated[str, FieldMetadata(alias="voiceId")]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class AgentConfigurationTts_Groq(UniversalBaseModel):
    """
    Text-to-Speech configuration that controls how the agent's voice sounds.
    This determines the personality and quality of the agent's speech.
    """

    provider: typing.Literal["groq"] = "groq"
    model: GroqTtsModel
    voice_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="voiceId")] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


AgentConfigurationTts = typing.Union[
    AgentConfigurationTts_Elevenlabs, AgentConfigurationTts_Cartesia, AgentConfigurationTts_Groq
]
