# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .agent import Agent
from .asset import Asset
from .phone import Phone
from .tool import Tool


class AgentDetailed(Agent):
    assets: typing.Optional[typing.List[Asset]] = pydantic.Field(default=None)
    """
    Knowledge base assets associated with the agent
    """

    phones: typing.Optional[typing.List[Phone]] = pydantic.Field(default=None)
    """
    Phone numbers assigned to this agent
    """

    tools: typing.Optional[typing.List[Tool]] = pydantic.Field(default=None)
    """
    Tools/functions available to this agent
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
