# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .anthropic_llm_model import AnthropicLlmModel


class AnthropicLlm(UniversalBaseModel):
    """
    Anthropic Claude language model configuration
    """

    model: AnthropicLlmModel = pydantic.Field()
    """
    Anthropic Claude model to use:
    - **claude-opus-4**: Most capable Claude model
    - **claude-sonnet-4**: Excellent for detailed, nuanced conversations
    - **claude-3-5-sonnet**: Previous generation, still very capable
    - **claude-3-haiku**: Fast and efficient
    """

    system_prompt: typing_extensions.Annotated[str, FieldMetadata(alias="systemPrompt")] = pydantic.Field()
    """
    **Most Important Setting**: This defines your agent's personality, knowledge, and behavior.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
