# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .api_key_creator import ApiKeyCreator


class ApiKey(UniversalBaseModel):
    pk_api_key_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    API key ID
    """

    api_key_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Descriptive name for the API key
    """

    created_at: typing.Optional[dt.datetime] = None
    last_used_at: typing.Optional[dt.datetime] = None
    is_active: typing.Optional[bool] = None
    expires_at: typing.Optional[dt.datetime] = None
    permissions: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    API key permissions
    """

    usage_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of times the key has been used
    """

    creator: typing.Optional[ApiKeyCreator] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
