# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .api_key_created_response_data_organization import ApiKeyCreatedResponseDataOrganization


class ApiKeyCreatedResponseData(UniversalBaseModel):
    id: typing.Optional[int] = pydantic.Field(default=None)
    """
    API key ID
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    API key name
    """

    api_key: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="apiKey")] = pydantic.Field(
        default=None
    )
    """
    The actual API key (only shown once)
    """

    organization: typing.Optional[ApiKeyCreatedResponseDataOrganization] = None
    expires_at: typing_extensions.Annotated[typing.Optional[dt.datetime], FieldMetadata(alias="expiresAt")] = None
    permissions: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None
    message: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
