# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .asset_type import AssetType


class Asset(UniversalBaseModel):
    pk_asset_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique asset identifier
    """

    fk_agent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the agent this asset belongs to
    """

    type: typing.Optional[AssetType] = pydantic.Field(default=None)
    """
    Type of asset:
    - **FILE**: Uploaded document (PDF, DOCX, etc.)
    - **TEXT**: Direct text input (FAQs, policies, etc.)
    - **TRAINING**: Q&A pairs for agent training
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human-readable title for the asset
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Cloud storage URL for the processed text
    """

    fk_user_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    ID of the user who created this asset
    """

    date_created: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the asset was created
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the asset is currently active
    """

    chunk_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of text chunks generated from this asset
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
