# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .asset_chunk_type import AssetChunkType


class AssetChunk(UniversalBaseModel):
    pk_chunk_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    Unique chunk identifier
    """

    type: typing.Optional[AssetChunkType] = pydantic.Field(default=None)
    """
    Type of content chunk:
    - **DOCUMENT**: Regular document content
    - **TRAINING_Q**: Training question
    - **TRAINING_A**: Training answer
    """

    chunk_text: typing.Optional[str] = pydantic.Field(default=None)
    """
    The actual text content of this chunk
    """

    date_created: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When this chunk was created
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
