# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .asset_configuration_file_processing import AssetConfigurationFileProcessing
from .asset_configuration_models import AssetConfigurationModels
from .asset_configuration_storage import AssetConfigurationStorage
from .asset_configuration_text_processing import AssetConfigurationTextProcessing
from .asset_configuration_vector_search import AssetConfigurationVectorSearch


class AssetConfiguration(UniversalBaseModel):
    file_processing: typing_extensions.Annotated[
        typing.Optional[AssetConfigurationFileProcessing], FieldMetadata(alias="fileProcessing")
    ] = None
    text_processing: typing_extensions.Annotated[
        typing.Optional[AssetConfigurationTextProcessing], FieldMetadata(alias="textProcessing")
    ] = None
    vector_search: typing_extensions.Annotated[
        typing.Optional[AssetConfigurationVectorSearch], FieldMetadata(alias="vectorSearch")
    ] = None
    models: typing.Optional[AssetConfigurationModels] = None
    storage: typing.Optional[AssetConfigurationStorage] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
