# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class AssetConfigurationTextProcessing(UniversalBaseModel):
    chunk_size: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="chunkSize")] = pydantic.Field(
        default=None
    )
    """
    Target size for text chunks
    """

    chunk_overlap: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="chunkOverlap")] = (
        pydantic.Field(default=None)
    )
    """
    Overlap between consecutive chunks
    """

    sanitization_enabled: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="sanitizationEnabled")
    ] = pydantic.Field(default=None)
    """
    Whether AI-powered text cleaning is enabled
    """

    min_text_length: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="minTextLength")] = (
        pydantic.Field(default=None)
    )
    """
    Minimum required text length
    """

    max_text_length: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="maxTextLength")] = (
        pydantic.Field(default=None)
    )
    """
    Maximum allowed text length
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
