# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata


class AssetConfigurationVectorSearch(UniversalBaseModel):
    embedding_model: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="embeddingModel")] = (
        pydantic.Field(default=None)
    )
    """
    AI model used for generating embeddings
    """

    vector_dimensions: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="vectorDimensions")] = (
        pydantic.Field(default=None)
    )
    """
    Number of dimensions in vector embeddings
    """

    default_similarity_threshold: typing_extensions.Annotated[
        typing.Optional[float], FieldMetadata(alias="defaultSimilarityThreshold")
    ] = pydantic.Field(default=None)
    """
    Default threshold for similarity searches
    """

    max_search_results: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="maxSearchResults")] = (
        pydantic.Field(default=None)
    )
    """
    Maximum number of search results returned
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
