# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from .asset import Asset
from .asset_chunk import AssetChunk
from .asset_detailed_creator import AssetDetailedCreator


class AssetDetailed(Asset):
    chunks: typing.Optional[typing.List[AssetChunk]] = pydantic.Field(default=None)
    """
    Text chunks generated from this asset (limited to first 20)
    """

    creator: typing.Optional[AssetDetailedCreator] = pydantic.Field(default=None)
    """
    User who created this asset
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
