# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class BaseResponse(UniversalBaseModel):
    success: bool = pydantic.Field()
    """
    Whether the request was successful
    """

    message: str = pydantic.Field()
    """
    Human-readable message describing the result
    """

    timestamp: dt.datetime = pydantic.Field()
    """
    ISO 8601 timestamp of the response
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
