# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .cartesia_tts_model import CartesiaTtsModel


class CartesiaTts(UniversalBaseModel):
    """
    Cartesia text-to-speech configuration
    """

    model: CartesiaTtsModel = pydantic.Field()
    """
    Cartesia TTS model quality:
    - **sonic-2**: Latest Cartesia model with improved quality
    - **sonic-english**: Optimized for English
    - **sonic-multilingual**: Multi-language support
    """

    voice_id: typing_extensions.Annotated[str, FieldMetadata(alias="voiceId")] = pydantic.Field()
    """
    Cartesia voice configuration (depends on Cartesia's voice system)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
