# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .create_tool_parameter_request_data_type import CreateToolParameterRequestDataType


class CreateToolParameterRequest(UniversalBaseModel):
    param_name: str = pydantic.Field()
    """
    Parameter name that will be sent to your API.
    Use snake_case format (e.g., customer_name, reservation_date).
    """

    data_type: CreateToolParameterRequestDataType = pydantic.Field()
    """
    Data type of the parameter:
    - **string**: Text values
    - **integer**: Whole numbers
    - **number**: Decimal numbers
    - **boolean**: true/false values
    - **array**: List of values
    - **object**: Complex nested data
    """

    is_mandatory: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this parameter must be provided
    """

    param_description: str = pydantic.Field()
    """
    Clear description of what this parameter represents.
    The agent uses this to understand how to populate the parameter.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
