# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .create_tool_parameter_request import CreateToolParameterRequest


class CreateToolRequest(UniversalBaseModel):
    tool_name: str = pydantic.Field()
    """
    Unique name for the tool. This will be the function name that the agent uses.
    Use snake_case format (e.g., make_reservation, get_weather, send_email).
    """

    tool_description: str = pydantic.Field()
    """
    Detailed description of what the tool does. The agent uses this to understand
    when and how to use the tool. Be specific about the tool's purpose and behavior.
    """

    server_url: str = pydantic.Field()
    """
    The API endpoint URL that will be called when the agent uses this tool.
    This should be a complete, accessible URL that accepts the specified HTTP method.
    """

    parameters: typing.Optional[typing.List[CreateToolParameterRequest]] = pydantic.Field(default=None)
    """
    Parameters that the tool accepts. Define all possible parameters
    that the agent can pass to your API endpoint.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
