# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .deepgram_stt_model import DeepgramSttModel


class DeepgramStt(UniversalBaseModel):
    """
    Deepgram speech-to-text configuration
    """

    model: DeepgramSttModel = pydantic.Field()
    """
    Deepgram STT model quality and speed:
    - **nova-3**: Latest, most accurate (recommended)
    - **nova-2**: Good balance of speed and accuracy
    - **enhanced**: Enhanced accuracy model
    - **base**: Faster but less accurate
    
    Specialized models available for different use cases:
    - **nova-3-medical**: Optimized for medical terminology
    - **nova-2-phonecall**: Optimized for phone call audio
    - **nova-2-meeting**: Optimized for meeting recordings
    """

    language: str = pydantic.Field()
    """
    Language code for speech recognition:
    - **en**: English
    - **es**: Spanish
    - **fr**: French
    - **de**: German
    And many more...
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
