# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .eleven_labs_tts_model import ElevenLabsTtsModel


class ElevenLabsTts(UniversalBaseModel):
    """
    ElevenLabs text-to-speech configuration
    """

    model: ElevenLabsTtsModel = pydantic.Field()
    """
    ElevenLabs TTS model quality:
    - **eleven_turbo_v2_5**: Latest, highest quality (recommended)
    - **eleven_flash_v2_5**: Fast with good quality
    - **eleven_multilingual_v2**: For multiple languages
    """

    voice_id: typing_extensions.Annotated[str, FieldMetadata(alias="voiceId")] = pydantic.Field()
    """
    ElevenLabs voice personality:
    - **burt**: Professional male voice
    - **marissa**: Friendly female voice
    - **andrea**: Energetic female voice
    - **sarah**: Professional female voice
    - **phillip**: Calm male voice
    - **steve**: Confident male voice
    - **joseph**: Warm male voice
    - **myra**: Cheerful female voice
    - **paula**: Professional female voice
    - **ryan**: Young male voice
    - **drew**: Casual male voice
    - **paul**: Mature male voice
    - **mrb**: British male voice
    - **matilda**: Young female voice
    - **mark**: Deep male voice
    
    OR any custom ElevenLabs voice ID string
    Test voices at: elevenlabs.io/voice-library
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
