# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .groq_llm_model import GroqLlmModel


class GroqLlm(UniversalBaseModel):
    """
    Groq language model configuration
    """

    model: GroqLlmModel = pydantic.Field()
    """
    Groq model to use:
    - **llama-3.3-70b-versatile**: Fast inference, good general performance
    - **llama-3.1-405b-reasoning**: Large model for complex reasoning
    - **deepseek-r1-distill-llama-70b**: Optimized reasoning model
    """

    system_prompt: typing_extensions.Annotated[str, FieldMetadata(alias="systemPrompt")] = pydantic.Field()
    """
    **Most Important Setting**: This defines your agent's personality, knowledge, and behavior.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
