# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .groq_tts_model import GroqTtsModel


class GroqTts(UniversalBaseModel):
    """
    Groq text-to-speech configuration
    """

    model: GroqTtsModel = pydantic.Field()
    """
    Groq TTS models:
    - **playai-tts**: High-quality TTS model for English speech generation
    - **playai-tts-arabic**: High-quality TTS model for Arabic speech generation
    """

    voice_id: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="voiceId")] = pydantic.Field(
        default=None
    )
    """
    Groq TTS voice configuration. Since Groq uses PlayAI models, voice options depend on the specific model:
    - For **playai-tts**: English voice options
    - For **playai-tts-arabic**: Arabic voice options
    
    Check Groq documentation for available voice IDs for each model.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
